/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.popup.LanguageInfoActivity;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.settings.AddonSettings;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.serializer.plain.PlainTextComponentSerializer;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.network.server.NetworkPayloadEvent;
import net.labymod.api.util.concurrent.task.Task;
import net.labymod.serverapi.api.payload.exception.PayloadReaderException;
import net.labymod.serverapi.api.payload.io.PayloadReader;

public class NetworkPayloadListener {
    private final MoneyMakerAddon addon;
    private boolean langInfoOpened = false;
    private boolean motdSent = false;

    public NetworkPayloadListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onNetworkPayload(NetworkPayloadEvent event) {
        if (event.identifier().getNamespace().equals("labymod3") & event.identifier().getPath().equals("main")) {
            try {
                PayloadReader reader = new PayloadReader(event.getPayload());
                String messageKey = reader.readString();
                String messageContent = reader.readString();
                JsonElement serverMessage = (JsonElement)this.addon.gson().fromJson(messageContent, JsonElement.class);
                if (serverMessage.isJsonObject()) {
                    JsonObject obj = serverMessage.getAsJsonObject();
                    if (messageKey.equals("discord_rpc") && obj.has("hasGame")) {
                        String gameMode = obj.get("game_mode").getAsString();
                        if (this.addon.addonUtil().inFarming() && gameMode.contains("Mine")) {
                            AddonSettings.FarmingReset farmingReset = (AddonSettings.FarmingReset)((Object)((MoneyMakerConfiguration)this.addon.configuration()).farmingAutoReset().get());
                            if (farmingReset == AddonSettings.FarmingReset.AUTOMATICALLY) {
                                this.addon.addonUtil().sessionBlocks(0);
                                this.addon.addonUtil().sessionKills(0);
                                Booster.sessionBoost.set(0);
                                Booster.sessionBoosters.set(0);
                                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.title", (TextColor)NamedTextColor.AQUA), (Component)Component.translatable((String)"moneymaker.notification.farming.left.done", (TextColor)NamedTextColor.YELLOW));
                            }
                            if (farmingReset == AddonSettings.FarmingReset.ASK_LABY) {
                                MoneyMakerAddon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.title", (TextColor)NamedTextColor.AQUA), (Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.question", (TextColor)NamedTextColor.GRAY), (Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.button", (Component[])new Component[0]), () -> {
                                    this.addon.addonUtil().sessionBlocks(0);
                                    this.addon.addonUtil().sessionKills(0);
                                    Booster.sessionBoost.set(0);
                                    Booster.sessionBoosters.set(0);
                                    this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.title", (TextColor)NamedTextColor.AQUA), (Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.done", (TextColor)NamedTextColor.YELLOW));
                                });
                            }
                            if (farmingReset == AddonSettings.FarmingReset.ASK_CHAT) {
                                this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.question", (TextColor)NamedTextColor.GRAY)));
                                Component askButton = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.button", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY));
                                askButton.clickEvent(ClickEvent.runCommand((String)"/mm-reset farming"));
                                askButton.hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"moneymaker.notification.dataReset.farming.buttonHover", (TextColor)NamedTextColor.GRAY)));
                                this.addon.displayMessage(this.addon.prefix.copy().append(askButton));
                            }
                        }
                        if (!gameMode.contains("Other")) {
                            this.addon.discordAPI().setSaved();
                        }
                        if (gameMode.contains("MoneyMaker")) {
                            this.addon.discordAPI().update();
                            this.addon.discordAPI().startUpdater();
                        } else if (this.addon.addonUtil().connectedToMoneyMaker()) {
                            this.addon.discordAPI().cancelUpdater();
                            this.addon.discordAPI().removeCustom();
                            this.addon.discordAPI().removeSaved();
                        }
                        this.addon.addonUtil().inMine(gameMode.contains("Mine"));
                        this.addon.addonUtil().inFarming(gameMode.contains("Farming"));
                        if (!this.addon.addonUtil().inFarming() && this.addon.moneyChatClient().isAuthenticated()) {
                            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()));
                        }
                        if (this.addon.addonUtil().inMine()) {
                            this.addon.sendServerUpdate("MoneyMaker \u00bb Mine");
                        }
                        if (this.addon.addonUtil().inFarming()) {
                            this.addon.sendServerUpdate("MoneyMaker \u00bb Farming");
                        }
                        if (this.addon.addonUtil().connectedToMoneyMaker()) {
                            if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).languageInfoClosed().get()).booleanValue() && !this.langInfoOpened) {
                                this.langInfoOpened = true;
                                Task.builder(() -> Laby.labyAPI().minecraft().executeNextTick(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new LanguageInfoActivity(this.addon, (ScreenInstance)Laby.labyAPI().minecraft().minecraftWindow().currentScreen())))).delay(2L, TimeUnit.SECONDS).build().execute();
                            }
                            if (!this.addon.addonUtil().motd().isEmpty() && !this.motdSent) {
                                boolean show = (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showMOTD().get();
                                if (this.addon.addonUtil().motdPriority()) {
                                    show = true;
                                }
                                if (show) {
                                    this.motdSent = true;
                                    this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.text.motd", (TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)":", (TextColor)NamedTextColor.DARK_GRAY)));
                                    this.addon.displayMessage((Component)PlainTextComponentSerializer.plainUrl().deserialize(this.addon.addonUtil().motd()));
                                }
                            }
                        }
                    }
                }
            }
            catch (PayloadReaderException payloadReaderException) {
                // empty catch block
            }
        }
    }
}

