/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.ChatUtil;
import de.timuuuu.moneymaker.utils.CurrencyUtil;
import de.timuuuu.moneymaker.utils.Util;
import java.io.IOException;
import net.labymod.api.Constants;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.scoreboard.ScoreboardScoreUpdateEvent;

public class ScoreBoardListener {
    private MoneyMakerAddon addon;
    private String cachedLanguage = "";

    public ScoreBoardListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onScoreboardScoreUpdate(ScoreboardScoreUpdateEvent event) {
        String language;
        String scoreName;
        if (!this.addon.addonUtil().connectedToMoneyMaker()) {
            return;
        }
        if (event.score().getValue() == MoneyScore.LANG_CHECK.score() && this.addon.chatMessageLoader().availableLanguages.containsKey(scoreName = ChatUtil.stripColor(event.score().getName())) && !(language = this.addon.chatMessageLoader().availableLanguages.get(scoreName)).equals(this.cachedLanguage)) {
            this.cachedLanguage = language;
            try {
                this.addon.chatMessageLoader().loadMessages("moneymaker", language);
            }
            catch (IOException e) {
                this.addon.logger().error((CharSequence)("Failed to load chat messages for " + language), (Throwable)e);
            }
        }
        if (event.score().getValue() == MoneyScore.BROKEN_BLOCKS.score() && this.addon.addonUtil().inFarming()) {
            scoreName = ChatUtil.stripColor(event.score().getName()).replace(".", "").replace(",", "");
            if (this.addon.addonUtil().ignoredRankingValues().contains(scoreName)) {
                return;
            }
            try {
                int blocks = Util.parseInteger(scoreName, this.getClass());
                this.addon.addonUtil().currentBrokenBlocks(blocks);
                if (this.addon.addonUtil().brokenBlocks() == 0) {
                    this.addon.addonUtil().brokenBlocks(blocks);
                } else {
                    this.addon.addonUtil().sessionBlocks(blocks - this.addon.addonUtil().brokenBlocks());
                    if (this.addon.addonSettings().breakGoalEnabled() && this.addon.addonSettings().breakGoal() != 0) {
                        if (this.addon.addonUtil().breakGoalBlocks() == 0) {
                            this.addon.addonUtil().breakGoalBlocks(blocks + this.addon.addonSettings().breakGoal());
                        }
                        if (blocks == this.addon.addonUtil().breakGoalBlocks()) {
                            this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.5f, 1.0f);
                            String readableTimeDifference = Util.convertToReadableFormat(System.currentTimeMillis() - this.addon.addonUtil().startTimestamp());
                            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.break-goal.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.break-goal.text", (TextColor)TextColor.color((int)170, (int)170, (int)170), (Component[])new Component[]{Component.text((String)readableTimeDifference, (TextColor)TextColor.color((int)255, (int)255, (int)85))}));
                            this.addon.addonSettings().breakGoalEnabled(false);
                            this.addon.addonSettings().breakGoal(0);
                            this.addon.addonUtil().breakGoalBlocks(0);
                        }
                    }
                }
            }
            catch (NumberFormatException blocks) {
                // empty catch block
            }
        }
        if (event.score().getValue() == MoneyScore.PICKAXE_LEVEL.score() && this.addon.addonUtil().inFarming()) {
            scoreName = ChatUtil.stripColor(event.score().getName());
            if (this.addon.addonUtil().ignoredRankingValues().contains(scoreName)) {
                return;
            }
            try {
                this.addon.addonUtil().pickaxeLevel(Util.parseInteger(ChatUtil.stripColor(event.score().getName()), this.getClass()));
            }
            catch (NumberFormatException blocks) {
                // empty catch block
            }
        }
        if (event.score().getValue() == MoneyScore.PICKAXE_RANKING.score() && this.addon.addonUtil().inFarming()) {
            scoreName = ChatUtil.stripColor(event.score().getName());
            if (this.addon.addonUtil().ignoredRankingValues().contains(scoreName)) {
                return;
            }
            if (scoreName.startsWith(this.addon.chatMessageLoader().message("scoreBoard.place"))) {
                this.addon.addonUtil().pickaxeRanking(Util.parseInteger(scoreName.replace(this.addon.chatMessageLoader().message("scoreBoard.place") + " ", "").replace(".", "").replace(",", ""), this.getClass()));
            }
        }
        if (event.score().getValue() == MoneyScore.RANK.score() && this.addon.addonUtil().connectedToMoneyMaker()) {
            scoreName = ChatUtil.stripColor(event.score().getName());
            if (this.addon.addonUtil().ignoredRankingValues().contains(scoreName)) {
                return;
            }
            if (scoreName.startsWith(this.addon.chatMessageLoader().message("scoreBoard.place"))) {
                this.addon.addonUtil().ranking(Util.parseInteger(scoreName.replace(this.addon.chatMessageLoader().message("scoreBoard.place") + " ", "").replace(".", "").replace(",", ""), this.getClass()));
            }
        }
        if (event.score().getValue() == MoneyScore.BALANCE.score() && this.addon.addonUtil().connectedToMoneyMaker()) {
            scoreName = ChatUtil.stripColor(event.score().getName());
            if (this.addon.addonUtil().ignoredRankingValues().contains(scoreName)) {
                return;
            }
            this.addon.addonUtil().balance(scoreName);
            try {
                String[] balSplit = this.addon.addonUtil().balance().replace(".", "").split(" ");
                if (balSplit.length == 1) {
                    return;
                }
                int balance = Util.parseInteger(balSplit[0], this.getClass());
                String balEinheit = balSplit[1];
                if (!this.addon.addonUtil().nextWorkerCost().equals("X") && !this.addon.addonUtil().workerNotifySent()) {
                    String[] workerSplit = this.addon.addonUtil().nextWorkerCost().replace(".", "").split(" ");
                    int workerCost = Util.parseInteger(workerSplit[0], this.getClass());
                    String workerEinheit = workerSplit[1];
                    if (CurrencyUtil.get(balEinheit) >= CurrencyUtil.get(workerEinheit) && balance >= workerCost && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.notifyOnMoneyReached().get()).booleanValue()) {
                        this.addon.addonUtil().workerNotifySent(true);
                        this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.balance-reached.miner.title", (TextColor)TextColor.color((int)85, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.balance-reached.miner.text", (TextColor)TextColor.color((int)170, (int)170, (int)170)));
                        this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.5f, 1.0f);
                    }
                }
                if (!this.addon.addonUtil().debrisCost().equals("X") && this.addon.addonUtil().nextWorkerCost().equals("X") && !this.addon.addonUtil().debrisNotifySent()) {
                    String[] debrisSplit = this.addon.addonUtil().debrisCost().replace(".", "").split(" ");
                    int debrisCost = Util.parseInteger(debrisSplit[0], this.getClass());
                    String debrisEinheit = debrisSplit[1];
                    if (CurrencyUtil.get(balEinheit) >= CurrencyUtil.get(debrisEinheit) && balance >= debrisCost && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).gameplayConfiguration.notifyOnMoneyReached().get()).booleanValue()) {
                        this.addon.addonUtil().debrisNotifySent(true);
                        this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.balance-reached.debris.title", (TextColor)TextColor.color((int)85, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.balance-reached.debris.text", (TextColor)TextColor.color((int)170, (int)170, (int)170)));
                        this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.5f, 1.0f);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static enum MoneyScore {
        BROKEN_BLOCKS(3),
        PICKAXE_LEVEL(6),
        PICKAXE_RANKING(0),
        RANK(9),
        BALANCE(12),
        LANG_CHECK(13);

        private final int score;

        private MoneyScore(int score) {
            this.score = score;
        }

        public int score() {
            return this.score;
        }
    }
}

