/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.listener;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.event.EventUtil;
import de.timuuuu.moneymaker.event.SwordTickEvent;
import de.timuuuu.moneymaker.events.CaveLevelChangeEvent;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.ChatUtil;
import de.timuuuu.moneymaker.utils.Util;
import java.util.List;
import java.util.Objects;
import net.labymod.api.Laby;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.util.StringUtil;

public class TickListener {
    private MoneyMakerAddon addon;
    private int swordTickCount = 0;
    private int generalTickCount = 0;

    public TickListener(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    @Subscribe
    public void onGameTick(GameTickEvent event) {
        if (!this.addon.addonUtil().inFarming()) {
            return;
        }
        if (this.addon.labyAPI().minecraft().getClientPlayer() == null) {
            return;
        }
        ++this.generalTickCount;
        if (this.generalTickCount >= this.addon.addonSettings().CHECK_TICK()) {
            this.generalTickCount = 0;
            double playerY = Objects.requireNonNull(this.addon.labyAPI().minecraft().getClientPlayer()).position().getY();
            AddonUtil.FarmingCave currentCave = this.addon.addonUtil().farmingCave();
            if (playerY > (double)AddonUtil.FarmingCave.GOLD.minY()) {
                if (currentCave != AddonUtil.FarmingCave.GOLD) {
                    Laby.fireEvent((Event)new CaveLevelChangeEvent(currentCave, AddonUtil.FarmingCave.GOLD));
                }
            } else if (playerY <= (double)AddonUtil.FarmingCave.COAL.maxY() && playerY > (double)AddonUtil.FarmingCave.COAL.minY()) {
                if (currentCave != AddonUtil.FarmingCave.COAL) {
                    Laby.fireEvent((Event)new CaveLevelChangeEvent(currentCave, AddonUtil.FarmingCave.COAL));
                }
            } else if (playerY <= (double)AddonUtil.FarmingCave.IRON.maxY()) {
                if (currentCave != AddonUtil.FarmingCave.IRON) {
                    Laby.fireEvent((Event)new CaveLevelChangeEvent(currentCave, AddonUtil.FarmingCave.IRON));
                }
            } else if (currentCave != AddonUtil.FarmingCave.UNKNOWN) {
                Laby.fireEvent((Event)new CaveLevelChangeEvent(currentCave, AddonUtil.FarmingCave.UNKNOWN));
            }
        }
    }

    @Subscribe
    public void onSwordTick(SwordTickEvent event) {
        if (!this.addon.addonUtil().inFarming()) {
            return;
        }
        ++this.swordTickCount;
        if (this.swordTickCount >= this.addon.addonSettings().CHECK_TICK()) {
            this.swordTickCount = 0;
            if (event.getLoreList().size() < 4) {
                return;
            }
            if (event.getLoreList().get(2) == null || event.getLoreList().get(3) == null) {
                return;
            }
            String rankingLine = event.getLoreList().get(2);
            String mobsLine = event.getLoreList().get(3);
            if (event.textVersion() == EventUtil.TextVersion.RAW) {
                rankingLine = ChatUtil.stripColor(rankingLine);
                mobsLine = ChatUtil.stripColor(mobsLine);
                if (rankingLine.startsWith("Ranking: ") && StringUtil.isNumeric((String)rankingLine.split(" ")[2])) {
                    this.addon.addonUtil().swordRanking(Util.parseInteger(rankingLine.split(" ")[2].replace(".", "").replace(",", ""), this.getClass()));
                }
                if (mobsLine.startsWith("Get\u00f6tete Mobs: ")) {
                    this.addon.addonUtil().swordMobs(Util.parseInteger(mobsLine.replace("Get\u00f6tete Mobs: ", "").replace(".", "").replace(",", ""), this.getClass()));
                }
                if (mobsLine.startsWith("Killed mobs: ")) {
                    this.addon.addonUtil().swordMobs(Util.parseInteger(mobsLine.replace("Killed mobs: ", "").replace(".", "").replace(",", ""), this.getClass()));
                }
            } else {
                List<String> line;
                if (rankingLine.contains("Ranking: ")) {
                    line = Util.getTextFromJsonObject(rankingLine);
                    if (line.size() != 3) {
                        return;
                    }
                    if (line.get(1) == null) {
                        return;
                    }
                    String text = line.get(1);
                    if (text.contains("Platz ")) {
                        this.addon.addonUtil().swordRanking(Util.parseInteger(text.replace("Platz ", "").replace(".", "").replace(",", "").strip(), this.getClass()));
                    }
                    if (text.contains("Rank ")) {
                        this.addon.addonUtil().swordRanking(Util.parseInteger(text.replace("Rank ", "").replace(".", "").replace(",", "").strip(), this.getClass()));
                    }
                }
                if (mobsLine.contains("Get\u00f6tete Mobs: ") || mobsLine.contains("Killed mobs: ")) {
                    line = Util.getTextFromJsonObject(mobsLine);
                    if (line.size() != 2) {
                        return;
                    }
                    if (line.get(1) == null) {
                        return;
                    }
                    this.addon.addonUtil().swordMobs(Util.parseInteger(line.get(1).replace(".", "").replace(",", ""), this.getClass()));
                }
            }
            if (this.addon.addonUtil().swordMobs() != 0) {
                if (this.addon.addonUtil().mobKills() == 0) {
                    this.addon.addonUtil().mobKills(this.addon.addonUtil().swordMobs());
                } else {
                    int sessionKills = this.addon.addonUtil().swordMobs() - this.addon.addonUtil().mobKills();
                    if (sessionKills >= 0) {
                        this.addon.addonUtil().sessionKills(sessionKills);
                    }
                }
            }
            if (this.addon.addonUtil().swordRanking() != 0 && this.addon.addonUtil().savedSwordRanking() == 0) {
                this.addon.addonUtil().savedSwordRanking(this.addon.addonUtil().swordRanking());
            }
        }
    }
}

