/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.moneychat.MoneyChatChannelHandler;
import de.timuuuu.moneymaker.moneychat.MoneyChatSession;
import de.timuuuu.moneymaker.moneychat.event.MoneyChatDisconnectEvent;
import de.timuuuu.moneymaker.moneychat.event.MoneyChatStateUpdateEvent;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyChatProtocol;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacket;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketDisconnect;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketLogin;
import de.timuuuu.moneymaker.moneychat.session.MoneySession;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.labymod.api.client.session.Session;
import net.labymod.api.client.session.SessionAccessor;
import net.labymod.api.concurrent.ThreadFactoryBuilder;
import net.labymod.api.event.Event;
import net.labymod.api.event.EventBus;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.network.server.ServerJoinEvent;
import net.labymod.api.event.client.session.SessionUpdateEvent;
import net.labymod.api.util.I18n;
import net.labymod.api.util.io.LabyExecutors;
import net.labymod.api.util.time.TimeUtil;

public class MoneyChatClient {
    private MoneyMakerAddon addon;
    private final String ADDRESS = "chat.moneymakeraddon.de";
    private final int PORT = 62894;
    private SessionAccessor sessionAccessor;
    private MoneyChatProtocol protocol = new MoneyChatProtocol();
    private MoneyChatState state;
    private MoneyChatSession session = null;
    private MoneyChatChannelHandler channelHandler = null;
    private Bootstrap bootstrap;
    private final NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(0, new ThreadFactoryBuilder().withNameFormat("MoneyChatNio#%d").build());
    private final ExecutorService executor = LabyExecutors.newFixedThreadPool((int)2, (String)"MoneyChatExecutor#%d");
    private final ScheduledExecutorService timeoutExecutor = LabyExecutors.newScheduledThreadPool((int)1, (String)"MoneyChatTimeoutExecutor#%d");
    private long timeLastKeepAlive;
    private long timeNextConnect;
    private boolean doNotConnect;
    private long lastConnectTriesReset;
    private String lastDisconnectReason;
    private int failedAuthenticationTries;

    public MoneyChatClient(MoneyMakerAddon addon, SessionAccessor sessionAccessor, EventBus eventBus) {
        this.addon = addon;
        this.state = MoneyChatState.OFFLINE;
        this.timeNextConnect = TimeUtil.getMillis();
        this.lastConnectTriesReset = 0L;
        this.sessionAccessor = sessionAccessor;
        this.failedAuthenticationTries = 0;
        eventBus.registerListener((Object)this);
    }

    public void prepareAsync() {
        LabyExecutors.executeBackgroundTask(this::prepare);
    }

    private void prepare() {
        this.timeoutExecutor.scheduleWithFixedDelay(() -> {
            try {
                long durationKeepAlive = TimeUtil.getMillis() - this.timeLastKeepAlive;
                long durationConnect = this.timeNextConnect - TimeUtil.getMillis();
                if (this.state != MoneyChatState.OFFLINE && durationKeepAlive > 25000L) {
                    this.disconnect(Initiator.CLIENT, I18n.translate((String)"moneymaker.ui.chat.protocol.disconnect.timeout", (Object[])new Object[0]), "Timeout");
                    this.addon.chatActivity().reloadScreen();
                }
                if (this.state == MoneyChatState.LOGIN && durationConnect < 0L && this.failedAuthenticationTries < 3) {
                    this.sendPacket(new MoneyPacketLogin(this.addon.labyAPI().getName(), this.addon.labyAPI().getUniqueId()));
                }
                if (this.state == MoneyChatState.OFFLINE && !this.doNotConnect && durationConnect < 0L) {
                    this.connect();
                }
                if (this.lastConnectTriesReset + 300000L < TimeUtil.getMillis()) {
                    this.lastConnectTriesReset = TimeUtil.getMillis();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public void connect() {
        this.doNotConnect = false;
        this.executor.execute(() -> {
            MoneyChatClient moneyChatClient = this;
            synchronized (moneyChatClient) {
                if (this.state == MoneyChatState.OFFLINE) {
                    this.keepAlive();
                    this.updateState(MoneyChatState.LOGIN);
                    Session session = this.sessionAccessor.getSession();
                    if (session == null) {
                        session = new MoneySession("Player", UUID.randomUUID(), null, Session.Type.LEGACY);
                    }
                    this.session = new MoneyChatSession(this.addon, this, session);
                    this.channelHandler = new MoneyChatChannelHandler(this, this.session);
                    this.lastDisconnectReason = null;
                    this.bootstrap = new Bootstrap();
                    this.bootstrap.group((EventLoopGroup)this.nioEventLoopGroup);
                    this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
                    this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                    this.bootstrap.channel(NioSocketChannel.class);
                    this.bootstrap.handler((ChannelHandler)this.channelHandler);
                    try {
                        this.bootstrap.connect("chat.moneymakeraddon.de", 62894).syncUninterruptibly();
                        this.addon.chatActivity().reloadScreen();
                        this.sendPacket(new MoneyPacketLogin(this.addon.labyAPI().getName(), this.addon.labyAPI().getUniqueId()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.updateState(MoneyChatState.OFFLINE);
                    }
                }
            }
        });
    }

    @Subscribe
    public void onSessionUpdate(SessionUpdateEvent event) {
        if (event.isAnotherAccount()) {
            this.disconnect(Initiator.USER, I18n.translate((String)"moneymaker.ui.chat.protocol.disconnect.sessionSwitch", (Object[])new Object[0]), "Session Switch");
            if (event.newSession().isPremium()) {
                this.connect();
            }
        }
    }

    @Subscribe
    public void onNetworkLogin(ServerJoinEvent event) {
        if (!this.isAuthenticated()) {
            this.timeNextConnect = TimeUtil.getMillis() + 10000L;
        }
    }

    public void disconnect(Initiator initiator, String reason, String serverReason) {
        long delay = (long)(1000.0 * Math.random() * 60.0);
        this.timeNextConnect = TimeUtil.getMillis() + 10000L + delay;
        if (this.doNotConnect && this.lastDisconnectReason != null) {
            this.lastDisconnectReason = reason;
        }
        if (this.state != MoneyChatState.OFFLINE) {
            if (this.session != null) {
                this.session.dispose();
            }
            this.fireEventSync(new MoneyChatDisconnectEvent(this, initiator, I18n.translate((String)reason, (Object[])new Object[0])));
            this.updateState(MoneyChatState.OFFLINE);
            this.sendPacket(new MoneyPacketDisconnect(serverReason == null ? "Logout" : serverReason), channel -> {
                if (channel.isOpen()) {
                    channel.close();
                }
            });
            this.session = null;
        }
    }

    public void sendPacket(MoneyPacket packet) {
        this.sendPacket(packet, null);
    }

    public void sendPacket(MoneyPacket packet, Consumer<NioSocketChannel> callback) {
        NioSocketChannel channel = this.getChannel();
        if (channel != null && channel.isActive()) {
            if (channel.eventLoop().inEventLoop()) {
                channel.writeAndFlush((Object)packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE});
                if (callback != null) {
                    callback.accept(channel);
                }
            } else {
                channel.eventLoop().execute(() -> {
                    channel.writeAndFlush((Object)packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE});
                    if (callback != null) {
                        callback.accept(channel);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(MoneyChatState state) {
        MoneyChatClient moneyChatClient = this;
        synchronized (moneyChatClient) {
            this.state = state;
        }
        this.fireEventSync(new MoneyChatStateUpdateEvent(this, this.state));
    }

    public void keepAlive() {
        this.timeLastKeepAlive = TimeUtil.getMillis();
    }

    public void fireEventSync(Event event) {
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> this.addon.labyAPI().eventBus().fire(event));
    }

    public boolean isAuthenticated() {
        return this.state == MoneyChatState.PLAY;
    }

    public boolean isConnectionEstablished() {
        return this.state != MoneyChatState.OFFLINE && this.session != null && this.session.isConnectionEstablished();
    }

    public NioSocketChannel getChannel() {
        return this.channelHandler == null ? null : this.channelHandler.getChannel();
    }

    public MoneyChatSession session() {
        return this.session;
    }

    public MoneyChatProtocol protocol() {
        return this.protocol;
    }

    public MoneyMakerAddon addon() {
        return this.addon;
    }

    public String getLastDisconnectReason() {
        return this.lastDisconnectReason;
    }

    public void timeNextConnect(long timeNextConnect) {
        this.timeNextConnect = timeNextConnect;
    }

    public void increaseFailedAuthenticationTries() {
        ++this.failedAuthenticationTries;
    }

    public void resetFailedAuthenticationTries() {
        this.failedAuthenticationTries = 0;
    }

    public static enum MoneyChatState {
        LOGIN(0),
        PLAY(1),
        ALL(2),
        OFFLINE(3);

        private final int id;

        private MoneyChatState(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum Initiator {
        USER,
        CLIENT,
        SERVER;

    }
}

