/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.popup.TokenVerificationActivity;
import de.timuuuu.moneymaker.events.MoneyChatReceiveEvent;
import de.timuuuu.moneymaker.events.MoneyPlayerStatusEvent;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.moneychat.MoneyChatClient;
import de.timuuuu.moneymaker.moneychat.message.DiscordLinkMessageListener;
import de.timuuuu.moneymaker.moneychat.message.MessageListener;
import de.timuuuu.moneymaker.moneychat.message.WebsiteRegistrationMessageListener;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacket;
import de.timuuuu.moneymaker.moneychat.protocol.MoneyPacketHandler;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketAddonMessage;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketDisconnect;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketPing;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketPong;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketAddonStatistics;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketClearChat;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessage;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessageDelete;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserMute;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserRankUpdate;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserUnmute;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketVerificationToken;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketEncryptionRequest;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketEncryptionResponse;
import de.timuuuu.moneymaker.moneychat.protocol.packets.auth.MoneyPacketLoginComplete;
import de.timuuuu.moneymaker.moneychat.util.CryptManager;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.MoneyPlayer;
import de.timuuuu.moneymaker.utils.Util;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.crypto.SecretKey;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.serializer.plain.PlainTextComponentSerializer;
import net.labymod.api.client.session.MinecraftAuthenticator;
import net.labymod.api.client.session.Session;
import net.labymod.api.event.Event;
import net.labymod.api.util.logging.Logging;
import net.labymod.api.util.time.TimeUtil;

public class MoneyChatSession
extends MoneyPacketHandler {
    private final MoneyMakerAddon addon;
    private final MoneyChatClient moneyChatClient;
    private final Logging LOGGER = Logging.getLogger();
    private Session session;
    private boolean premium;
    private boolean connectionEstablished;
    private boolean authenticated;
    private boolean muted;
    private String muteReason;
    private long muteDuration;
    private final Map<String, MessageListener> messageListeners;

    public MoneyChatSession(MoneyMakerAddon addon, MoneyChatClient moneyChatClient, Session session) {
        this.addon = addon;
        this.moneyChatClient = moneyChatClient;
        this.session = session;
        this.premium = session.isPremium();
        this.connectionEstablished = false;
        this.authenticated = false;
        this.messageListeners = new HashMap<String, MessageListener>();
        this.registerMessageListeners();
    }

    private void registerMessageListeners() {
        this.messageListeners.put("unauthenticated", MessageListener2 -> this.resetAuthentication());
        this.messageListeners.put("website_register", new WebsiteRegistrationMessageListener(this.moneyChatClient.addon()));
        this.messageListeners.put("discord_link", new DiscordLinkMessageListener(this.moneyChatClient.addon()));
    }

    @Override
    protected void handlePacket(MoneyPacket packet) {
        this.connectionEstablished = true;
        super.handlePacket(packet);
        this.moneyChatClient.keepAlive();
    }

    @Override
    public void handle(MoneyPacketEncryptionRequest encryptionRequest) {
        try {
            PublicKey publicKey = CryptManager.decodePublicKey(encryptionRequest.getPublicKey());
            SecretKey secretKey = CryptManager.createNewSharedKey();
            String serverId = encryptionRequest.getServerId();
            MinecraftAuthenticator authenticator = this.moneyChatClient.addon().labyAPI().minecraft().authenticator();
            String hash = CryptManager.getServerIdHash(serverId, publicKey, secretKey);
            NioSocketChannel nio = this.moneyChatClient.getChannel();
            ((CompletableFuture)authenticator.joinServer(this.session, hash).exceptionally(throwable -> false)).thenAccept(result -> {
                if (this.moneyChatClient.getChannel() == nio) {
                    this.moneyChatClient.sendPacket(new MoneyPacketEncryptionResponse(secretKey.getEncoded()));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.moneyChatClient.disconnect(MoneyChatClient.Initiator.CLIENT, e.getMessage(), "Client Error - EncryptionRequest");
        }
    }

    @Override
    public void handle(MoneyPacketPing packet) {
        this.moneyChatClient.sendPacket(new MoneyPacketPong());
        this.moneyChatClient.keepAlive();
    }

    @Override
    public void handle(MoneyPacketLoginComplete packet) {
        this.moneyChatClient.updateState(MoneyChatClient.MoneyChatState.PLAY);
        this.authenticated = true;
        this.moneyChatClient.resetFailedAuthenticationTries();
        this.moneyChatClient.keepAlive();
        this.moneyChatClient.addon().chatActivity().reloadScreen();
        this.moneyChatClient.sendPacket(new PacketAddonStatistics("add", this.session.getUniqueId(), this.session.getUsername(), this.moneyChatClient.addon().addonInfo().getVersion(), this.moneyChatClient.addon().labyAPI().minecraft().getVersion(), this.moneyChatClient.addon().labyAPI().labyModLoader().isAddonDevelopmentEnvironment()));
        this.moneyChatClient.sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), (Boolean)((MoneyMakerConfiguration)this.moneyChatClient.addon().configuration()).chatConfiguration.hideOnlineStatus.get()));
    }

    @Override
    public void handle(PacketMessage packet) {
        Laby.fireEvent((Event)new MoneyChatReceiveEvent(packet.message()));
    }

    @Override
    public void handle(PacketClearChat packet) {
        this.moneyChatClient.addon().chatActivity().clearChat(true);
    }

    @Override
    public void handle(PacketMessageDelete packet) {
        this.moneyChatClient.addon().chatActivity().deleteMessage(packet.messageId());
    }

    @Override
    public void handle(PacketUserMute packet) {
        if (this.moneyChatClient.addon().labyAPI().getUniqueId().equals(packet.targetUUID())) {
            this.muted = true;
            this.muteReason = packet.reason();
            this.muteDuration = packet.duration();
            this.addon.chatActivity().addCustomChatMessage((Component)Component.translatable((String)"moneymaker.mute.ui.muted", (TextColor)NamedTextColor.RED));
            this.addon.chatActivity().reloadScreen();
        }
    }

    @Override
    public void handle(PacketUserUnmute packet) {
        if (this.moneyChatClient.addon().labyAPI().getUniqueId().equals(packet.targetUUID())) {
            this.muted = false;
            this.muteReason = "";
            this.addon.chatActivity().addCustomChatMessage((Component)Component.translatable((String)"moneymaker.mute.ui.unmuted", (TextColor)NamedTextColor.GREEN));
            this.addon.chatActivity().reloadScreen();
        }
    }

    @Override
    public void handle(PacketUserRankUpdate packet) {
        UUID uuid = UUID.fromString(packet.uuid());
        Group group = GroupService.getGroup(packet.rank());
        if (group != null) {
            if (AddonUtil.playerStatus.containsKey(uuid)) {
                AddonUtil.playerStatus.get(uuid).group(group);
            }
            if (this.addon.labyAPI().getUniqueId().equals(uuid)) {
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.chat.rank-changed.title", (TextColor)NamedTextColor.GREEN), (Component)Component.translatable((String)"moneymaker.notification.chat.rank-changed.text", (TextColor)NamedTextColor.YELLOW, (Component[])new Component[]{Component.text((String)group.getDisplayName(), (TextColor)group.getTextColor())}), group.getIcon());
            }
        }
    }

    @Override
    public void handle(PacketPlayerStatus packet) {
        Laby.fireEvent((Event)new MoneyPlayerStatusEvent(packet.uuid(), new MoneyPlayer(packet.uuid(), packet.username(), packet.server(), packet.addonVersion(), packet.minecraftVersion(), packet.group(), packet.hideOnlineStatus())));
    }

    @Override
    public void handle(MoneyPacketDisconnect packet) {
        this.moneyChatClient.disconnect(MoneyChatClient.Initiator.SERVER, packet.reason(), packet.reason());
    }

    @Override
    public void handle(MoneyPacketAddonMessage packet) {
        String key = packet.getKey();
        MessageListener listener = this.messageListeners.get(key);
        if (listener != null) {
            listener.listen(packet.getJson());
        } else {
            this.LOGGER.debug((CharSequence)"Unknown addon message {}", new Object[]{key});
        }
    }

    @Override
    public void handle(PacketVerificationToken packet) {
        if (packet.type() != null && packet.token() != null) {
            if (this.addon.tokenVerificationActivity().isScreenOpened()) {
                this.addon.tokenVerificationActivity().setToken(packet.type(), packet.token());
                return;
            }
            if (packet.type() == TokenVerificationActivity.TokenType.WEBSITE) {
                this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.verification.chat.website.success", (TextColor)NamedTextColor.GREEN)));
                this.addon.displayMessage(PlainTextComponentSerializer.plainUrl().deserialize("https://moneymakeraddon.de/register?token=" + packet.token()).color(NamedTextColor.YELLOW));
            } else {
                this.addon.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.verification.chat.discord.success", (TextColor)NamedTextColor.GREEN)));
                TranslatableComponent tokenComponent = Component.translatable((String)"moneymaker.verification.chat.discord.token", (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)packet.token(), (TextColor)NamedTextColor.YELLOW)});
                tokenComponent.hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"moneymaker.verification.chat.discord.tokenHover", (TextColor)NamedTextColor.GRAY)));
                tokenComponent.clickEvent(ClickEvent.copyToClipboard((String)packet.token()));
                this.addon.displayMessage(this.addon.prefix.copy().append((Component)tokenComponent));
            }
        }
    }

    public void dispose() {
        this.connectionEstablished = false;
    }

    private void resetAuthentication() {
        this.authenticated = false;
        this.premium = false;
        this.moneyChatClient.updateState(MoneyChatClient.MoneyChatState.LOGIN);
        this.moneyChatClient.increaseFailedAuthenticationTries();
        long delay = (long)(1000.0 * Math.random() * 60.0);
        this.moneyChatClient.timeNextConnect(TimeUtil.getMillis() + 10000L + delay);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public boolean isConnectionEstablished() {
        return this.connectionEstablished;
    }

    public boolean muted() {
        return this.muted;
    }

    public String muteReason() {
        return this.muteReason;
    }

    public long muteDuration() {
        return this.muteDuration;
    }
}

