/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.moneychat.util;

import com.google.gson.JsonObject;
import de.timuuuu.moneymaker.group.Group;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.utils.MoneyTextures;
import java.util.UUID;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.gui.icon.Icon;

public class MoneyChatMessage {
    private String messageId;
    private UUID uuid;
    private String userName;
    private String message;
    private Group group;
    private MessageType messageType;
    private boolean deleted = false;
    private boolean fromServerCache;
    private String timeStamp;
    private String addonVersion;
    private String minecraftVersion;

    public MoneyChatMessage(String messageId, UUID uuid, String userName, String message, Group group, boolean fromServerCache, String timeStamp, String addonVersion, String minecraftVersion) {
        this.messageId = messageId;
        this.uuid = uuid;
        this.userName = userName;
        this.message = message;
        this.group = group;
        this.messageType = MessageType.getMessageType(uuid.toString());
        this.fromServerCache = fromServerCache;
        this.timeStamp = timeStamp;
        this.addonVersion = addonVersion;
        this.minecraftVersion = minecraftVersion;
    }

    public static MoneyChatMessage fromJson(JsonObject object) {
        if (object.has("uuid")) {
            return new MoneyChatMessage(object.get("messageId").getAsString(), UUID.fromString(object.get("uuid").getAsString()), object.get("userName").getAsString(), object.get("message").getAsString(), object.has("rank") ? GroupService.getGroup(object.get("rank").getAsString()) : GroupService.getGroup("user"), object.has("fromCache") && object.get("fromCache").getAsBoolean(), object.has("timeStamp") ? object.get("timeStamp").getAsString() : null, object.has("addonVersion") ? object.get("addonVersion").getAsString() : "N/A", object.has("minecraftVersion") ? object.get("minecraftVersion").getAsString() : "N/A");
        }
        return null;
    }

    public String messageId() {
        return this.messageId;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String userName() {
        return this.userName;
    }

    public String message() {
        return this.message;
    }

    public void message(String message) {
        this.message = message;
    }

    public Group group() {
        return this.group;
    }

    public MessageType messageType() {
        return this.messageType;
    }

    public boolean fromServerCache() {
        return this.fromServerCache;
    }

    public String timeStamp() {
        return this.timeStamp;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public void deleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String addonVersion() {
        return this.addonVersion;
    }

    public String minecraftVersion() {
        return this.minecraftVersion;
    }

    public static enum MessageType {
        PLAYER(null, null, null),
        SERVER("00000000-0000-0000-0000-000000000000", Component.text((String)"SYSTEM", (TextColor)NamedTextColor.DARK_RED).decorate(TextDecoration.BOLD), MoneyTextures.SpriteCommon.SERVER),
        DISCORD("00000000-0000-0000-0000-000000000001", Component.text((String)"Discord", (TextColor)TextColor.color((int)88, (int)101, (int)242)).decorate(TextDecoration.BOLD), MoneyTextures.SpriteCommon.DISCORD);

        private final String uuid;
        private final Component userName;
        private final Icon icon;

        private MessageType(String uuid, Component userName, Icon icon) {
            this.uuid = uuid;
            this.userName = userName;
            this.icon = icon;
        }

        public String uuid() {
            return this.uuid;
        }

        public Component userName() {
            return this.userName;
        }

        public Icon icon() {
            return this.icon;
        }

        public static MessageType getMessageType(String uuid) {
            MessageType messageType = PLAYER;
            for (MessageType type : MessageType.values()) {
                if (type.uuid() == null || !uuid.equals(type.uuid())) continue;
                messageType = type;
            }
            return messageType;
        }
    }
}

