/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.moneychat.protocol.packets.MoneyPacketAddonMessage;
import de.timuuuu.moneymaker.settings.AddonSettings;
import de.timuuuu.moneymaker.settings.MoneyBadgeConfiguration;
import de.timuuuu.moneymaker.settings.MoneyChatConfiguration;
import de.timuuuu.moneymaker.settings.MoneyDiscordConfiguration;
import de.timuuuu.moneymaker.settings.MoneyGameplayConfiguration;
import net.labymod.api.addon.AddonConfig;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.configuration.loader.annotation.ConfigName;
import net.labymod.api.configuration.loader.annotation.Exclude;
import net.labymod.api.configuration.loader.annotation.IntroducedIn;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.annotation.SpriteTexture;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.util.MethodOrder;

@ConfigName(value="settings")
@SpriteTexture(value="sprite/settings")
public class MoneyMakerConfiguration
extends AddonConfig {
    @SettingSection(value="general", center=true)
    @SpriteSlot
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> enabled = new ConfigProperty((Object)true);
    @SpriteSlot(y=1)
    public MoneyDiscordConfiguration discordConfiguration = new MoneyDiscordConfiguration();
    @SpriteSlot(x=1)
    public MoneyChatConfiguration chatConfiguration = new MoneyChatConfiguration();
    @IntroducedIn(value="0.0.5", namespace="moneymaker")
    @SpriteSlot(y=7)
    public MoneyBadgeConfiguration badgeConfiguration = new MoneyBadgeConfiguration();
    @IntroducedIn(value="1.4.2", namespace="moneymaker")
    public MoneyGameplayConfiguration gameplayConfiguration = new MoneyGameplayConfiguration();
    @IntroducedIn(value="1.6.5", namespace="moneymaker")
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> showCustomGameSwitchNotifications = new ConfigProperty((Object)true);
    @IntroducedIn(value="1.1.0", namespace="moneymaker")
    @SpriteSlot(y=3, x=3)
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> exportBoosterOnShutdown = new ConfigProperty((Object)false);
    @IntroducedIn(value="1.2.3", namespace="moneymaker")
    @SpriteSlot(y=3, x=2)
    @DropdownWidget.DropdownSetting
    @DropdownWidget.DropdownEntryTranslationPrefix(value="moneymaker.settings.farmingAutoReset.type")
    private final ConfigProperty<AddonSettings.FarmingReset> farmingAutoReset = new ConfigProperty((Object)AddonSettings.FarmingReset.ASK_LABY);
    @IntroducedIn(value="1.5.1", namespace="moneymaker")
    @SpriteSlot(y=3, x=2)
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> resetOnProfileSwitch = new ConfigProperty((Object)false);
    @IntroducedIn(value="1.3.0", namespace="moneymaker")
    @SpriteSlot(y=3, x=1)
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> showWidgetsAlways = new ConfigProperty((Object)false);
    @IntroducedIn(value="1.3.0", namespace="moneymaker")
    @SpriteSlot(y=3)
    @DropdownWidget.DropdownSetting
    @DropdownWidget.DropdownEntryTranslationPrefix(value="moneymaker.settings.updateMode.type")
    private final ConfigProperty<AddonSettings.UpdateMode> updateMode = new ConfigProperty((Object)AddonSettings.UpdateMode.NORMAL);
    @IntroducedIn(value="1.4.2", namespace="moneymaker")
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> showTotalBoostMessage = new ConfigProperty((Object)true);
    @IntroducedIn(value="1.6.0", namespace="moneymaker")
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> showMOTD = new ConfigProperty((Object)true);
    @Exclude
    private final ConfigProperty<Boolean> chatReconnectButton = new ConfigProperty((Object)false);
    @Exclude
    private final ConfigProperty<Boolean> chatShowAllPlayers = new ConfigProperty((Object)false);
    @Exclude
    private final ConfigProperty<Boolean> languageInfoClosed = new ConfigProperty((Object)false);
    @Exclude
    private final ConfigProperty<Integer> chatRulesVersion = new ConfigProperty((Object)0);

    @SettingSection(value="account", center=true)
    @IntroducedIn(value="1.7.0", namespace="moneymaker")
    @MethodOrder(after="gameplayConfiguration")
    @ButtonWidget.ButtonSetting
    public void createWebsiteAccount() {
        MoneyMakerAddon addon = MoneyMakerAddon.instance();
        if (addon.moneyChatClient().isAuthenticated()) {
            JsonObject payload = new JsonObject();
            payload.addProperty("uuid", addon.labyAPI().getUniqueId().toString());
            payload.addProperty("username", addon.labyAPI().getName());
            addon.moneyChatClient().sendPacket(new MoneyPacketAddonMessage("website_register", (JsonElement)payload));
            addon.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)addon.tokenVerificationActivity());
        } else {
            addon.pushNotification((Component)Component.translatable((String)"moneymaker.verification.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.verification.request.chatNotConnected", (TextColor)TextColor.color((int)255, (int)85, (int)85)));
        }
    }

    @IntroducedIn(value="1.7.0", namespace="moneymaker")
    @MethodOrder(after="createWebsiteAccount")
    @ButtonWidget.ButtonSetting
    public void linkDiscordAccount() {
        MoneyMakerAddon addon = MoneyMakerAddon.instance();
        if (addon.moneyChatClient().isAuthenticated()) {
            JsonObject payload = new JsonObject();
            payload.addProperty("uuid", addon.labyAPI().getUniqueId().toString());
            payload.addProperty("username", addon.labyAPI().getName());
            addon.moneyChatClient().sendPacket(new MoneyPacketAddonMessage("discord_link", (JsonElement)payload));
            addon.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)addon.tokenVerificationActivity());
        } else {
            addon.pushNotification((Component)Component.translatable((String)"moneymaker.verification.title", (TextColor)TextColor.color((int)255, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.verification.request.chatNotConnected", (TextColor)TextColor.color((int)255, (int)85, (int)85)));
        }
    }

    @SettingSection(value="other", center=true)
    @MethodOrder(before="showCustomGameSwitchNotifications")
    @ButtonWidget.ButtonSetting
    public void showBlocksInLeaderboard() {
        MoneyMakerAddon addon = MoneyMakerAddon.instance();
        if (addon.addonUtil().leaderboardShowBlocks()) {
            addon.addonUtil().leaderboardShowBlocks(false);
            addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.leaderboard.title", (TextColor)NamedTextColor.GOLD), ((TranslatableComponent)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.disabled", (TextColor)NamedTextColor.RED).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.info", (TextColor)NamedTextColor.GRAY)));
        } else {
            addon.addonUtil().leaderboardShowBlocks(true);
            addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.leaderboard.title", (TextColor)NamedTextColor.GOLD), ((TranslatableComponent)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.enabled", (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)"\n"))).append((Component)Component.translatable((String)"moneymaker.notification.leaderboard.blocks.info", (TextColor)NamedTextColor.GRAY)));
        }
    }

    public ConfigProperty<Boolean> enabled() {
        return this.enabled;
    }

    public ConfigProperty<Boolean> showCustomGameSwitchNotifications() {
        return this.showCustomGameSwitchNotifications;
    }

    public ConfigProperty<Boolean> exportBoosterOnShutdown() {
        return this.exportBoosterOnShutdown;
    }

    public ConfigProperty<AddonSettings.FarmingReset> farmingAutoReset() {
        return this.farmingAutoReset;
    }

    public ConfigProperty<Boolean> resetOnProfileSwitch() {
        return this.resetOnProfileSwitch;
    }

    public ConfigProperty<Boolean> showWidgetsAlways() {
        return this.showWidgetsAlways;
    }

    public ConfigProperty<AddonSettings.UpdateMode> updateMode() {
        return this.updateMode;
    }

    public ConfigProperty<Boolean> showTotalBoostMessage() {
        return this.showTotalBoostMessage;
    }

    public ConfigProperty<Boolean> showMOTD() {
        return this.showMOTD;
    }

    public ConfigProperty<Boolean> chatReconnectButton() {
        return this.chatReconnectButton;
    }

    public ConfigProperty<Boolean> chatShowAllPlayers() {
        return this.chatShowAllPlayers;
    }

    public ConfigProperty<Boolean> languageInfoClosed() {
        return this.languageInfoClosed;
    }

    public ConfigProperty<Integer> chatRulesVersion() {
        return this.chatRulesVersion;
    }
}

