/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Constants;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.util.concurrent.task.Task;

public class MoneyTimer {
    private String name;
    private int minutes;
    private int seconds;
    private Task task;

    public MoneyTimer(String name, int minutes) {
        this.name = name;
        this.minutes = minutes;
        this.seconds = minutes * 60;
    }

    public String name() {
        return this.name;
    }

    public int minutes() {
        return this.minutes;
    }

    public Task task() {
        return this.task;
    }

    public MoneyTimer start() {
        this.task = Task.builder(() -> {
            --this.seconds;
            if (this.seconds == 0) {
                this.task.cancel();
                Util.timers.remove(this.name);
                MoneyMakerAddon.instance().labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_MARKER_NOTIFY, 0.5f, 1.0f);
                MoneyMakerAddon.instance().pushNotification((Component)Component.translatable((String)"moneymaker.notification.timer.finished.title", (Component[])new Component[0]), (Component)Component.translatable((String)"moneymaker.notification.timer.finished.text", (TextColor)TextColor.color((int)170, (int)170, (int)170), (Component[])new Component[]{Component.text((String)this.name, (TextColor)TextColor.color((int)255, (int)255, (int)85))}));
                MoneyMakerAddon.instance().startActivity().reloadScreen();
            }
        }).repeat(1L, TimeUnit.SECONDS).build();
        this.task.execute();
        return this;
    }

    public String remainingTime() {
        long seconds = this.seconds;
        long minutes = 0L;
        while (seconds >= 60L) {
            seconds -= 60L;
            ++minutes;
        }
        Object secString = String.valueOf(seconds);
        Object minString = String.valueOf(minutes);
        if (((String)minString).length() == 1) {
            minString = "0" + (String)minString;
        }
        if (((String)secString).length() == 1) {
            secString = "0" + (String)secString;
        }
        return (String)minString + ":" + (String)secString;
    }
}

