/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.MoneyTextures;
import de.timuuuu.moneymaker.utils.MoneyTimer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.models.OperatingSystem;

public class Util {
    public static final String DISCORD_INVITE_URL = "https://discord.moneymakeraddon.de/";
    public static HashMap<String, MoneyTimer> timers = new HashMap();

    public static String currentServer() {
        if (MoneyMakerAddon.instance().addonUtil().inMine()) {
            return Util.currentMine(MoneyMakerAddon.instance().addonUtil().currentMine());
        }
        if (MoneyMakerAddon.instance().addonUtil().inFarming()) {
            return Util.currentCave(MoneyMakerAddon.instance().addonUtil().farmingCave());
        }
        return "Other";
    }

    public static String currentMine(AddonUtil.MineType mine) {
        if (mine == null) {
            return "Mine";
        }
        if (!((Boolean)((MoneyMakerConfiguration)MoneyMakerAddon.instance().configuration()).chatConfiguration.showDetailedLocation().get()).booleanValue()) {
            return "Mine";
        }
        return "Mine - " + mine.internalName();
    }

    public static String currentCave(AddonUtil.FarmingCave cave) {
        if (!((Boolean)((MoneyMakerConfiguration)MoneyMakerAddon.instance().configuration()).chatConfiguration.showDetailedLocation().get()).booleanValue()) {
            return "Farming";
        }
        return "Farming - " + cave.internalName();
    }

    public static ButtonWidget feedbackButton() {
        ButtonWidget feedbackButton = (ButtonWidget)ButtonWidget.component((Component)((TextComponent)Component.text((String)"Feedback", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" / ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"Bugreport", (TextColor)NamedTextColor.RED)), (Icon)MoneyTextures.SpriteCommon.BUG).addId("feedback-button");
        feedbackButton.setPressable(() -> OperatingSystem.getPlatform().openUrl("https://moneymakeraddon.de/feedback?mcname=" + Laby.labyAPI().getName() + "&mcversion=" + Laby.labyAPI().minecraft().getVersion()));
        return feedbackButton;
    }

    public static ButtonWidget discordButton() {
        ButtonWidget discordButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.button.discord", (Icon)MoneyTextures.SpriteCommon.DISCORD).addId("discord-button");
        discordButton.setPressable(() -> OperatingSystem.getPlatform().openUrl(DISCORD_INVITE_URL));
        return discordButton;
    }

    public static ButtonWidget leaderboardButton() {
        ButtonWidget leaderboardButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.button.leaderboard").addId("leaderboard-button");
        leaderboardButton.setPressable(() -> OperatingSystem.getPlatform().openUrl("https://moneymakeraddon.de/leaderboard/"));
        return leaderboardButton;
    }

    public static void addCredits(MoneyMakerAddon addon, Document document) {
        DivWidget container = (DivWidget)new DivWidget().addId("mm-credit-container");
        ComponentWidget addonVersionWidget = (ComponentWidget)ComponentWidget.component((Component)((TextComponent)Component.text((String)"Addon-Version", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)addon.addonInfo().getVersion(), (TextColor)NamedTextColor.YELLOW))).addId("credits-addon-version");
        container.addChild((Widget)addonVersionWidget);
        ComponentWidget developerWidget = (ComponentWidget)ComponentWidget.component((Component)((TextComponent)((TextComponent)Component.text((String)"Developed by ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)"MisterCore", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" & ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"Seelenverwandter", (TextColor)NamedTextColor.YELLOW))).addId("credits-developer");
        container.addChild((Widget)developerWidget);
        document.addChild((Widget)container);
    }

    public static String format(int toFormate) {
        return new DecimalFormat("#,###", new DecimalFormatSymbols(Locale.GERMAN)).format(toFormate);
    }

    public static int parseInteger(String input, Class clazz) throws NumberFormatException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            MoneyMakerAddon.instance().logger().warn((CharSequence)("Unable to parse Input to Integer (Input: '" + input + "', Used in '" + clazz.getName() + "')"), new Object[0]);
            throw numberFormatException;
        }
    }

    public static boolean isAdmin(UUID uuid) {
        if (!AddonUtil.playerStatus.containsKey(uuid)) {
            return false;
        }
        return AddonUtil.playerStatus.get(uuid).group().isAdmin();
    }

    public static boolean isStaff(UUID uuid) {
        if (!AddonUtil.playerStatus.containsKey(uuid)) {
            return false;
        }
        return AddonUtil.playerStatus.get(uuid).group().isStaff();
    }

    public static int timeToInt(String input, boolean hours) {
        if (!input.contains(":")) {
            return 0;
        }
        String[] split = input.split(":");
        if (hours ? split.length != 3 : split.length != 2) {
            return 0;
        }
        int seconds = 0;
        try {
            if (!hours) {
                seconds = Util.parseInteger(split[1], Util.class);
                seconds += Util.parseInteger(split[0], Util.class) * 60;
            } else {
                seconds = Util.parseInteger(split[2], Util.class);
                seconds += Util.parseInteger(split[1], Util.class) * 60;
                seconds += Util.parseInteger(split[0], Util.class) * 60 * 60;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return seconds;
    }

    public static String intToTime(int time) {
        long seconds = time;
        long minutes = 0L;
        long hours = 0L;
        while (seconds >= 60L) {
            seconds -= 60L;
            ++minutes;
        }
        while (minutes >= 60L) {
            minutes -= 60L;
            ++hours;
        }
        Object secString = String.valueOf(seconds);
        Object minString = String.valueOf(minutes);
        Object hourString = String.valueOf(hours);
        if (((String)hourString).length() == 1) {
            hourString = "0" + (String)hourString;
        }
        if (((String)minString).length() == 1) {
            minString = "0" + (String)minString;
        }
        if (((String)secString).length() == 1) {
            secString = "0" + (String)secString;
        }
        return (String)hourString + ":" + (String)minString + ":" + (String)secString;
    }

    public static List<String> getTextFromJsonObject(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JsonObject object = JsonParser.parseString((String)input).getAsJsonObject();
            if (object.has("extra") && object.get("extra").isJsonArray()) {
                JsonArray array = object.get("extra").getAsJsonArray();
                for (int i = 0; i != array.size(); ++i) {
                    if (!array.get(i).isJsonObject() || !array.get(i).getAsJsonObject().has("text")) continue;
                    list.add(array.get(i).getAsJsonObject().get("text").getAsString());
                }
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return list;
    }

    public static String convertToReadableFormat(long milliseconds) {
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds) % 60L;
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds + "s";
        }
        return seconds + "s";
    }
}

