/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.widgets.BoosterWidget;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.utils.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.Links;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.TilesGridWidget;
import net.labymod.api.models.OperatingSystem;

@AutoActivity
@Links(value={@Link(value="booster.lss"), @Link(value="buttons.lss")})
public class BoosterActivity
extends SimpleActivity {
    MoneyMakerAddon addon;
    private Sorting sorting = Sorting.DESCENDING;

    public BoosterActivity(MoneyMakerAddon addon) {
        this.addon = addon;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ComponentWidget titleWidget = ComponentWidget.i18n((String)"moneymaker.ui.booster.title");
        titleWidget.addId("title");
        ((Document)this.document).addChild((Widget)titleWidget);
        AtomicInteger boost = new AtomicInteger(0);
        Booster.boosterList().forEach(booster -> boost.getAndAdd(booster.boost() * booster.amount()));
        DivWidget container = (DivWidget)new DivWidget().addId("container");
        LinkedList<Booster> list = new LinkedList<Booster>(Booster.boosterList());
        if (this.sorting == Sorting.ASCENDING) {
            list.sort(Comparator.comparing(Booster::boost));
        }
        if (this.sorting == Sorting.TIME) {
            list.sort(Comparator.comparing(Booster::farmDate));
        }
        TilesGridWidget boosters = (TilesGridWidget)new TilesGridWidget().addId("booster-grid");
        list.forEach(booster -> boosters.addTile((Widget)new BoosterWidget((Booster)booster)));
        container.addChild((Widget)new ScrollWidget((Widget)boosters, new ListSession()));
        DivWidget sideContainer = (DivWidget)new DivWidget().addId("side-container");
        ComponentWidget totalBoostWidget = ComponentWidget.component((Component)Component.translatable((String)"moneymaker.ui.booster.boost-total", (TextColor)TextColor.color((int)255, (int)255, (int)85), (Component[])new Component[]{Component.text((String)(boost.get() + "%"), (TextColor)TextColor.color((int)255, (int)170, (int)0))}));
        totalBoostWidget.addId("total-boost");
        sideContainer.addChild((Widget)totalBoostWidget);
        ComponentWidget averageBoostersWidget = (ComponentWidget)ComponentWidget.component((Component)Component.translatable((String)"moneymaker.ui.booster.average-boosters", (TextColor)TextColor.color((int)255, (int)255, (int)85)).append((Component)Component.text((String)(Booster.sessionBoosters.get() > 0 && this.addon.addonUtil().sessionBlocks() > 0 ? "\n" + (float)Booster.sessionBoosters.get() / (float)this.addon.addonUtil().sessionBlocks() + " (" + (float)Booster.sessionBoosters.get() / (float)this.addon.addonUtil().sessionBlocks() * 100.0f + " %)" : "\nN/A"), (TextColor)TextColor.color((int)255, (int)170, (int)0)))).addId("average-boosters");
        sideContainer.addChild((Widget)averageBoostersWidget);
        ComponentWidget boostersPerBlocksWidget = (ComponentWidget)ComponentWidget.component((Component)((TextComponent)((TextComponent)Component.text((String)(Booster.sessionBoosters.get() + " Boosters"), (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)" / ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)(this.addon.addonUtil().sessionBlocks() + " "), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.translatable((String)"moneymaker.hudWidget.mm_block_session.blocks", (TextColor)NamedTextColor.YELLOW))).addId("boosters-per-block");
        sideContainer.addChild((Widget)boostersPerBlocksWidget);
        ButtonWidget exportBtnWidget = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.booster.export").addId("export-button");
        exportBtnWidget.setPressable(() -> BoosterActivity.writeLinkedListToCSV(false));
        ButtonWidget clearListButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.ui.booster.clear").addId("clear-button");
        clearListButton.setPressable(() -> {
            if (!Booster.boosterList().isEmpty()) {
                Booster.boosterList().clear();
                this.addon.labyAPI().minecraft().executeOnRenderThread(() -> ((BoosterActivity)this).reload());
            }
        });
        ButtonWidget sortButton = (ButtonWidget)ButtonWidget.component((Component)Component.translatable((String)"moneymaker.ui.booster.sorting.button", (TextColor)NamedTextColor.GOLD).append(((TextComponent)Component.text((String)" (", (TextColor)NamedTextColor.DARK_GRAY).append(this.sortIcon())).append((Component)Component.text((String)")", (TextColor)NamedTextColor.DARK_GRAY)))).addId("sort-button");
        sortButton.setPressable(() -> {
            switch (this.sorting.ordinal()) {
                case 0: {
                    this.sorting = Sorting.ASCENDING;
                    break;
                }
                case 1: {
                    this.sorting = Sorting.TIME;
                    break;
                }
                case 2: {
                    this.sorting = Sorting.DESCENDING;
                }
            }
            this.reload();
        });
        sideContainer.addChild((Widget)sortButton);
        sideContainer.addChild((Widget)clearListButton);
        sideContainer.addChild((Widget)exportBtnWidget);
        ((Document)this.document).addChild((Widget)container);
        ((Document)this.document).addChild((Widget)sideContainer);
        ((Document)this.document).addChild((Widget)Util.feedbackButton());
        ((Document)this.document).addChild((Widget)Util.discordButton());
        ((Document)this.document).addChild((Widget)Util.leaderboardButton());
        Util.addCredits(this.addon, (Document)this.document);
    }

    private Component sortIcon() {
        if (this.sorting == Sorting.ASCENDING) {
            return Component.text((String)"\u2b06", (TextColor)NamedTextColor.AQUA);
        }
        if (this.sorting == Sorting.TIME) {
            return Component.text((String)"\u231a", (TextColor)NamedTextColor.AQUA);
        }
        return Component.text((String)"\u2b07", (TextColor)NamedTextColor.AQUA);
    }

    public static void writeLinkedListToCSV(boolean quit) {
        if (Booster.boosterList().isEmpty()) {
            if (!quit) {
                MoneyMakerAddon.instance().pushNotification((Component)Component.translatable((String)"moneymaker.notification.booster-export.title", (Component[])new Component[0]), (Component)Component.translatable((String)"moneymaker.notification.booster-export.no-boosters", (TextColor)TextColor.color((int)255, (int)85, (int)85)));
            }
            return;
        }
        try {
            File folder = new File(Laby.labyAPI().labyModLoader().getGameDirectory().toFile(), "MoneyMaker");
            if (!folder.exists()) {
                folder.mkdir();
            }
            String time = new SimpleDateFormat("dd_MM_yy-HH_mm").format(new Date());
            File file = new File(folder, "BoosterExport_" + time + ".csv");
            FileWriter writer = new FileWriter(file);
            writer.write("Anzahl;Booster;Zeit\n\n");
            for (Booster entry : Booster.boosterList()) {
                writer.write(entry.toExport() + "\n");
            }
            writer.close();
            MoneyMakerAddon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.booster-export.title", (Component[])new Component[0]), (Component)Component.translatable((String)"moneymaker.notification.booster-export.saved", (TextColor)TextColor.color((int)85, (int)255, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.booster-export.open-folder", (Component[])new Component[0]), () -> OperatingSystem.getPlatform().openFile(folder));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static enum Sorting {
        DESCENDING,
        ASCENDING,
        TIME;

    }
}

