/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.activities.popup.ChatRulesActivity;
import de.timuuuu.moneymaker.activities.popup.MuteActivity;
import de.timuuuu.moneymaker.activities.widgets.ChatMessageWidget;
import de.timuuuu.moneymaker.activities.widgets.OnlineEntryWidget;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.moneychat.MoneyChatClient;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketClearChat;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketMessage;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketPlayerStatus;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketUserUnmute;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.AddonUtil;
import de.timuuuu.moneymaker.utils.MoneyPlayer;
import de.timuuuu.moneymaker.utils.Util;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.Constants;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.util.I18n;
import net.labymod.api.util.concurrent.task.Task;
import net.labymod.api.util.io.web.result.Result;

@AutoActivity
@Link(value="chat.lss")
public class ChatActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private int MESSAGE_LIMIT = 50;
    private TextFieldWidget chatInput;
    private static List<ChatMessageWidget> chatMessages = new ArrayList<ChatMessageWidget>();
    private ListSession<Widget> listSession = new ListSession();

    public ChatActivity(MoneyMakerAddon addon) {
        this.addon = addon;
        this.chatInput = new TextFieldWidget();
        this.chatInput.addId("chat-input");
        this.chatInput.maximalLength(200);
        this.chatInput.submitHandler(message -> this.submitMessage());
        this.listSession.scrollToBottom();
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.chat.title").addId("chat-title");
        ((Document)this.document).addChild((Widget)titleWidget);
        ComponentWidget statusWidget = this.addon.moneyChatClient().isAuthenticated() ? ComponentWidget.i18n((String)"moneymaker.ui.chat.server.online", (TextColor)NamedTextColor.GREEN) : ComponentWidget.i18n((String)"moneymaker.ui.chat.server.offline", (TextColor)NamedTextColor.RED);
        statusWidget.addId("chat-status");
        ((Document)this.document).addChild((Widget)statusWidget);
        ButtonWidget rulesButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.chat-rules.button").addId("rules-button");
        rulesButton.setPressable(() -> {
            try {
                ChatRulesActivity.create(this.addon, (ScreenInstance)this.addon.labyAPI().minecraft().minecraftWindow().currentScreen(), false, chatRulesActivity -> {
                    if (chatRulesActivity == null) {
                        return;
                    }
                    this.addon.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)chatRulesActivity);
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        ((Document)this.document).addChild((Widget)rulesButton);
        if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatReconnectButton().get()).booleanValue()) {
            ButtonWidget reconnectButton = ButtonWidget.i18n((String)"moneymaker.ui.chat.server.reconnect-button");
            reconnectButton.addId("chat-reconnect-button");
            reconnectButton.setPressable(() -> {
                this.addon.moneyChatClient().disconnect(MoneyChatClient.Initiator.USER, "Reconnecting to Chat Server...", "Reconnect");
                this.reloadScreen();
                reconnectButton.setEnabled(false);
                Task.builder(() -> {
                    this.addon.moneyChatClient().connect();
                    Laby.labyAPI().minecraft().executeOnRenderThread(() -> reconnectButton.setEnabled(true));
                }).delay(5L, TimeUnit.SECONDS).build().execute();
            });
            ((Document)this.document).addChild((Widget)reconnectButton);
        }
        SwitchWidget chatReconnectSwitch = (SwitchWidget)SwitchWidget.create(value -> {
            ((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.set((Object)value);
            this.addon.moneyChatClient().sendPacket(new PacketPlayerStatus(Laby.labyAPI().getUniqueId(), Laby.labyAPI().getName(), GroupService.getGroup("user"), Util.currentServer(), MoneyMakerAddon.instance().addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion(), Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment(), value));
        }).addId("hide-online-switch");
        chatReconnectSwitch.setValue(((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatConfiguration.hideOnlineStatus.get()).booleanValue());
        ((Document)this.document).addChild((Widget)chatReconnectSwitch);
        ComponentWidget chatReconnectTitle = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.chat.hide-online-status").addId("hide-online-title");
        ((Document)this.document).addChild((Widget)chatReconnectTitle);
        AtomicInteger onlineCount = new AtomicInteger(0);
        AddonUtil.playerStatus.values().forEach(moneyPlayer -> {
            String server = moneyPlayer.server();
            if ((server.startsWith("Mine") || server.startsWith("Farming")) && !moneyPlayer.hideOnlineStatus()) {
                onlineCount.getAndIncrement();
            }
        });
        ComponentWidget onlineTextWidget = (ComponentWidget)ComponentWidget.component((Component)Component.translatable((String)"moneymaker.ui.chat.online", (TextColor)NamedTextColor.AQUA, (Component[])new Component[]{Component.text((Object)onlineCount, (TextColor)NamedTextColor.YELLOW)})).addId("chat-online-text");
        ((Document)this.document).addChild((Widget)onlineTextWidget);
        DivWidget onlineContainer = new DivWidget();
        onlineContainer.addId("online-container");
        VerticalListWidget onlineList = (VerticalListWidget)new VerticalListWidget().addId("online-list");
        if (this.addon.moneyChatClient().isAuthenticated()) {
            ArrayList<MoneyPlayer> players = new ArrayList<MoneyPlayer>(AddonUtil.playerStatus.values());
            players.sort(Comparator.comparing(moneyPlayer -> {
                if (moneyPlayer.group() != null) {
                    return moneyPlayer.group().getId();
                }
                return GroupService.getGroup("user").getId();
            }));
            if (Util.isAdmin(this.addon.labyAPI().getUniqueId()) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatShowAllPlayers().get()).booleanValue()) {
                onlineList.addChild((Widget)new OnlineEntryWidget(this.addon, Component.text((String)"\u2192 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"Online auf MoneyMaker", (TextColor)NamedTextColor.GRAY))));
            }
            players.forEach(moneyPlayer -> {
                String server = moneyPlayer.server();
                if (server.startsWith("Mine") || server.startsWith("Farming")) {
                    boolean hideOnlineStatus = moneyPlayer.hideOnlineStatus() && Util.isAdmin(this.addon.labyAPI().getUniqueId());
                    onlineList.addChild((Widget)new OnlineEntryWidget(this.addon, (MoneyPlayer)moneyPlayer, false, hideOnlineStatus));
                }
            });
            if (Util.isAdmin(this.addon.labyAPI().getUniqueId()) && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).chatShowAllPlayers().get()).booleanValue()) {
                onlineList.addChild((Widget)new OnlineEntryWidget(this.addon, Component.text((String)"\u2192 ", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"Online andere Server", (TextColor)NamedTextColor.GRAY))));
                players.forEach(moneyPlayer -> {
                    if (moneyPlayer.server().equalsIgnoreCase("Other")) {
                        onlineList.addChild((Widget)new OnlineEntryWidget(this.addon, (MoneyPlayer)moneyPlayer, true, false));
                    }
                });
            }
        }
        ScrollWidget onlineScroll = (ScrollWidget)new ScrollWidget((Widget)onlineList, new ListSession()).addId("online-scroll");
        onlineContainer.addChild((Widget)onlineScroll);
        DivWidget chatContainer = (DivWidget)new DivWidget().addId("chat-container");
        VerticalListWidget chatList = (VerticalListWidget)new VerticalListWidget().addId("chat-messages");
        if (chatMessages.size() <= this.MESSAGE_LIMIT) {
            chatMessages.forEach(arg_0 -> ((VerticalListWidget)chatList).addChild(arg_0));
        } else {
            int size = chatMessages.size();
            for (int i = size - this.MESSAGE_LIMIT; i != chatMessages.size(); ++i) {
                chatList.addChild((Widget)chatMessages.get(i));
            }
        }
        ScrollWidget chatScroll = (ScrollWidget)new ScrollWidget((Widget)chatList, this.listSession).addId("chat-scroll");
        chatContainer.addChild((Widget)chatScroll);
        DivWidget inputContainer = (DivWidget)new DivWidget().addId("input-container");
        if (this.addon.moneyChatClient().isAuthenticated()) {
            if (this.addon.moneyChatClient().session().muted() & !Util.isStaff(this.labyAPI.getUniqueId())) {
                ComponentWidget componentWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.chat.muted.title").addId("chat-muted-title");
                ComponentWidget infoWidget = (ComponentWidget)ComponentWidget.component((Component)Component.translatable((String)"moneymaker.ui.chat.muted.info", (Component[])new Component[]{Component.text((String)this.addon.moneyChatClient().session().muteReason(), (TextColor)NamedTextColor.YELLOW), Component.text((String)net.labymod.api.util.TimeUnit.parseToString((long)(this.addon.moneyChatClient().session().muteDuration() - System.currentTimeMillis())), (TextColor)NamedTextColor.YELLOW)})).addId("chat-muted-info");
                inputContainer.addChild((Widget)componentWidget);
                inputContainer.addChild((Widget)infoWidget);
            } else {
                inputContainer.addChild((Widget)this.chatInput);
            }
        } else {
            ComponentWidget componentWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.ui.chat.server-offline").addId("chat-error");
            inputContainer.addChild((Widget)componentWidget);
        }
        ((Document)this.document).addChild((Widget)chatContainer);
        ((Document)this.document).addChild((Widget)onlineContainer);
        ((Document)this.document).addChild((Widget)inputContainer);
        if (!chatMessages.isEmpty()) {
            chatScroll.scrollToBottom();
        }
    }

    public void onOpenScreen() {
        super.onOpenScreen();
        try {
            ChatRulesActivity.create(this.addon, (ScreenInstance)this.addon.labyAPI().minecraft().minecraftWindow().currentScreen(), true, chatRulesActivity -> {
                if (chatRulesActivity == null) {
                    return;
                }
                if (chatRulesActivity.rules().has("version") && ((Integer)((MoneyMakerConfiguration)this.addon.configuration()).chatRulesVersion().get()).intValue() == chatRulesActivity.rules().get("version").getAsInt()) {
                    return;
                }
                this.addon.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)chatRulesActivity);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void submitMessage() {
        String message = this.chatInput.getText();
        if (!(message = message.trim()).isEmpty()) {
            if (message.startsWith("/") & Util.isStaff(this.labyAPI.getUniqueId())) {
                this.handleCommands(message);
                this.chatInput.setText("");
                return;
            }
            this.sendToServer(message);
            this.addon.labyAPI().minecraft().sounds().playSound(Constants.Resources.SOUND_CHAT_MESSAGE, 0.35f, 1.0f);
            this.chatInput.setText("");
            if (!Util.isAdmin(this.labyAPI.getUniqueId())) {
                this.chatInput.setEditable(false);
                this.chatInput.addId("blocked");
                Task.builder(() -> {
                    this.reloadScreen();
                    this.addon.labyAPI().minecraft().executeNextTick(() -> {
                        this.chatInput.setFocused(true);
                        this.chatInput.setEditable(true);
                        this.chatInput.removeId("blocked");
                    });
                }).delay(3L, TimeUnit.SECONDS).build().execute();
            } else {
                this.addon.labyAPI().minecraft().executeNextTick(() -> this.chatInput.setFocused(true));
            }
        }
    }

    private void handleCommands(String input) {
        String playerName;
        String[] args;
        if (!Util.isStaff(this.labyAPI.getUniqueId())) {
            return;
        }
        if (input.equalsIgnoreCase("/clear")) {
            this.addon.moneyChatClient().sendPacket(new PacketClearChat(this.labyAPI.getUniqueId(), this.labyAPI.getName()));
        }
        if (input.startsWith("/mute")) {
            args = input.split(" ");
            if (args.length >= 3) {
                playerName = args[1];
                StringBuilder builder = new StringBuilder();
                for (int i = 2; i != args.length; ++i) {
                    builder.append(args[i]).append(" ");
                }
                String reason = builder.toString().trim();
                Result requestUuid = this.labyAPI.labyNetController().loadUniqueIdByNameSync(playerName);
                if (requestUuid.hasException()) {
                    this.addCustomChatMessage((Component)Component.text((String)("Failed to get uuid from " + playerName + ":"), (TextColor)NamedTextColor.DARK_RED));
                    this.addCustomChatMessage((Component)Component.text((String)requestUuid.exception().getMessage(), (TextColor)NamedTextColor.RED));
                    return;
                }
                UUID uuid = (UUID)requestUuid.get();
                if (Util.isStaff(uuid)) {
                    this.addCustomChatMessage((Component)Component.text((String)"Du kannst keine Teammitglieder muten.", (TextColor)NamedTextColor.RED));
                    return;
                }
                this.addon.labyAPI().minecraft().executeNextTick(() -> this.addon.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new MuteActivity(this.addon, this.addon.labyAPI().getUniqueId(), this.addon.labyAPI().getName(), playerName, uuid, (ScreenInstance)this.addon.labyAPI().minecraft().minecraftWindow().currentScreen(), reason)));
            } else {
                this.addCustomChatMessage((Component)Component.text((String)"Bitte nutze /mute <Spieler> <Grund>", (TextColor)NamedTextColor.RED));
                return;
            }
        }
        if (input.startsWith("/unmute")) {
            args = input.split(" ");
            if (args.length == 2) {
                playerName = args[1];
                Result requestUuid = this.labyAPI.labyNetController().loadUniqueIdByNameSync(playerName);
                if (requestUuid.hasException()) {
                    this.addCustomChatMessage((Component)Component.text((String)("Failed to get uuid from " + playerName + ":"), (TextColor)NamedTextColor.DARK_RED));
                    this.addCustomChatMessage((Component)Component.text((String)requestUuid.exception().getMessage(), (TextColor)NamedTextColor.RED));
                    return;
                }
                this.addon.moneyChatClient().sendPacket(new PacketUserUnmute(this.labyAPI.getUniqueId(), this.labyAPI.getName(), (UUID)requestUuid.get(), playerName));
                this.addCustomChatMessage(((TextComponent)Component.text((String)"Du hast ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)playerName, (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" erfolgreich entmutet.", (TextColor)NamedTextColor.GRAY)));
            } else {
                this.addCustomChatMessage((Component)Component.text((String)"Bitte nutze /unmute <Spieler>", (TextColor)NamedTextColor.RED));
            }
        }
    }

    public void addChatMessage(MoneyChatMessage chatMessage) {
        if (chatMessage == null) {
            return;
        }
        String CURRENT_TIME = new SimpleDateFormat("dd.MM HH:mm").format(new Date());
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> {
            if (chatMessages.size() <= this.MESSAGE_LIMIT) {
                chatMessages.add((ChatMessageWidget)new ChatMessageWidget(this.addon, chatMessage.fromServerCache() ? chatMessage.timeStamp() : CURRENT_TIME, chatMessage).addId("chat-message"));
            } else {
                chatMessages.removeFirst();
                chatMessages.add((ChatMessageWidget)new ChatMessageWidget(this.addon, chatMessage.fromServerCache() ? chatMessage.timeStamp() : CURRENT_TIME, chatMessage).addId("chat-message"));
            }
            this.reloadScreen();
        });
    }

    public void clearChat(boolean message) {
        chatMessages.clear();
        if (message) {
            String CURRENT_TIME = new SimpleDateFormat("dd.MM HH:mm").format(new Date());
            this.addon.labyAPI().minecraft().executeOnRenderThread(() -> chatMessages.add((ChatMessageWidget)new ChatMessageWidget(this.addon, CURRENT_TIME, (Component)Component.translatable((String)"moneymaker.ui.chat.chatCleared", (TextColor)NamedTextColor.DARK_RED)).addId("chat-message")));
        }
        this.reloadScreen();
    }

    public void deleteMessage(String id) {
        ArrayList<ChatMessageWidget> remove = new ArrayList<ChatMessageWidget>();
        for (ChatMessageWidget messageWidget : chatMessages) {
            if (messageWidget.chatMessage() == null || !messageWidget.chatMessage().messageId().equals(id)) continue;
            if (messageWidget.messageType() != MoneyChatMessage.MessageType.PLAYER) {
                remove.add(messageWidget);
                continue;
            }
            messageWidget.chatMessage().deleted(true);
            if (Util.isAdmin(this.addon.labyAPI().getUniqueId())) continue;
            messageWidget.chatMessage().message("\u00a77\u00a7o" + I18n.translate((String)"moneymaker.ui.chat.messageDeleted", (Object[])new Object[0]));
        }
        if (!remove.isEmpty()) {
            chatMessages.removeAll(remove);
        }
        this.reloadScreen();
    }

    public void addCustomChatMessage(Component chatMessage) {
        if (chatMessage == null) {
            return;
        }
        String CURRENT_TIME = new SimpleDateFormat("dd.MM HH:mm").format(new Date());
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> {
            if (chatMessages.size() <= this.MESSAGE_LIMIT) {
                chatMessages.add(new ChatMessageWidget(this.addon, CURRENT_TIME, chatMessage));
            } else {
                chatMessages.removeFirst();
                chatMessages.add(new ChatMessageWidget(this.addon, CURRENT_TIME, chatMessage));
            }
            this.reloadScreen();
        });
    }

    public void reloadScreen() {
        if (!this.isOpen()) {
            return;
        }
        this.addon.labyAPI().minecraft().executeOnRenderThread(() -> ((ChatActivity)this).reload());
    }

    private void sendToServer(String message) {
        MoneyChatMessage chatMessage = new MoneyChatMessage("UNKNOWN", this.addon.labyAPI().getUniqueId(), this.addon.labyAPI().getName(), message, GroupService.getGroup("user"), false, "N/A", this.addon.addonInfo().getVersion(), this.addon.labyAPI().minecraft().getVersion());
        this.addon.moneyChatClient().sendPacket(new PacketMessage(chatMessage));
    }
}

