/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.popup;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.moneychat.protocol.packets.PacketReport;
import de.timuuuu.moneymaker.moneychat.util.MoneyChatMessage;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="popup/report.lss")
@AutoActivity
public class ChatReportActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private UUID reporterUUID;
    private String reporterName;
    private MoneyChatMessage chatMessage;
    private UUID uuid;
    private String userName;
    private ScreenInstance previousScreen;
    private ReportReason reportReason = ReportReason.SPAM;

    public ChatReportActivity(MoneyMakerAddon addon, UUID reporterUUID, String reporterName, MoneyChatMessage chatMessage, ScreenInstance previousScreen) {
        this.addon = addon;
        this.reporterUUID = reporterUUID;
        this.reporterName = reporterName;
        this.chatMessage = chatMessage;
        this.uuid = chatMessage.uuid();
        this.userName = chatMessage.userName();
        this.previousScreen = previousScreen;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.report.form.title", (Object[])new Object[]{this.userName}).addId("title");
        header.addEntry((Widget)headWidget);
        header.addEntry((Widget)titleWidget);
        ComponentWidget messageTitleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.report.form.message").addId("message-title");
        TextFieldWidget messageInputWidget = (TextFieldWidget)new TextFieldWidget().addId("message-input");
        messageInputWidget.setEditable(false);
        messageInputWidget.setText(this.chatMessage.message());
        ComponentWidget reasonTitleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.report.form.reason.title").addId("reason-title");
        DropdownWidget reasonDropdownWidget = (DropdownWidget)DropdownWidget.create((Object)((Object)ReportReason.SPAM), reason -> {
            this.reportReason = reason;
        }).addId("reason-input");
        reasonDropdownWidget.setTranslationKeyPrefix("moneymaker.report.form.reason.type");
        reasonDropdownWidget.addAll((Object[])ReportReason.values());
        ButtonWidget sendButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.report.form.send").addId("send-button");
        sendButton.setPressable(() -> {
            this.addon.moneyChatClient().sendPacket(new PacketReport(this.uuid, this.userName, this.reporterUUID, this.reporterName, this.reportReason.getName(), this.chatMessage.message()));
            Laby.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen);
            this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.report.form.success.title", (TextColor)NamedTextColor.DARK_GREEN), (Component)Component.translatable((String)"moneymaker.report.form.success.text", (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{Component.text((String)this.userName, (TextColor)NamedTextColor.YELLOW)}));
        });
        ButtonWidget closeButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.report.form.abort").addId("close-button");
        closeButton.setPressable(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen));
        FlexibleContentWidget content = (FlexibleContentWidget)new FlexibleContentWidget().addId("content");
        FlexibleContentWidget messageContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("message-container");
        messageContainer.addContent((Widget)messageTitleWidget);
        messageContainer.addContent((Widget)messageInputWidget);
        content.addContent((Widget)messageContainer);
        FlexibleContentWidget reasonContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("reason-container");
        reasonContainer.addContent((Widget)reasonTitleWidget);
        reasonContainer.addContent((Widget)reasonDropdownWidget);
        content.addContent((Widget)reasonContainer);
        FlexibleContentWidget buttonContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("button-container");
        buttonContainer.addContent((Widget)sendButton);
        buttonContainer.addContent((Widget)closeButton);
        content.addContent((Widget)buttonContainer);
        container.addContent((Widget)header);
        container.addContent((Widget)content);
        ((Document)this.document).addChild((Widget)container);
    }

    public static enum ReportReason {
        SPAM("Spamming"),
        CHOICEOFWORDS("Wortwahl"),
        BEHAVIOR("Verhalten"),
        ADVERTISING("Werbung"),
        PROVOCATION("Provokation"),
        OTHER("Sonstiges");

        private final String name;

        private ReportReason(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

