/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.popup;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;

@Link(value="popup/language.lss")
@AutoActivity
public class LanguageInfoActivity
extends SimpleActivity {
    private MoneyMakerAddon addon;
    private ScreenInstance previousScreen;

    public LanguageInfoActivity(MoneyMakerAddon addon, ScreenInstance previousScreen) {
        this.addon = addon;
        this.previousScreen = previousScreen;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"moneymaker.language-info.title").addId("title");
        header.addEntry((Widget)titleWidget);
        FlexibleContentWidget descriptionContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("description-container");
        ComponentWidget line1 = ComponentWidget.i18n((String)"moneymaker.language-info.line1", (TextColor)NamedTextColor.RED);
        ComponentWidget line2 = ComponentWidget.i18n((String)"moneymaker.language-info.line2", (TextColor)NamedTextColor.GRAY);
        descriptionContainer.addContent((Widget)line1);
        descriptionContainer.addContent((Widget)line2);
        ButtonWidget closeButton = (ButtonWidget)ButtonWidget.i18n((String)"moneymaker.mute.form.close").addId("close-button");
        closeButton.setPressable(() -> {
            Laby.labyAPI().minecraft().minecraftWindow().displayScreen(this.previousScreen);
            ((MoneyMakerConfiguration)this.addon.configuration()).languageInfoClosed().set((Object)true);
            this.addon.saveConfiguration();
        });
        FlexibleContentWidget buttonContainer = (FlexibleContentWidget)new FlexibleContentWidget().addId("button-container");
        buttonContainer.addContent((Widget)closeButton);
        FlexibleContentWidget content = (FlexibleContentWidget)new FlexibleContentWidget().addId("content");
        content.addContent((Widget)descriptionContainer);
        content.addContent((Widget)buttonContainer);
        container.addContent((Widget)header);
        container.addContent((Widget)content);
        ((Document)this.document).addChild((Widget)container);
    }
}

