/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.activities.widgets;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.utils.MoneyTimer;
import de.timuuuu.moneymaker.utils.Util;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;

public class TimerWidget
extends HorizontalListWidget {
    private MoneyMakerAddon addon;
    private MoneyTimer timer;

    public TimerWidget(MoneyMakerAddon addon, MoneyTimer timer) {
        this.addon = addon;
        this.timer = timer;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ButtonWidget cancelButton = (ButtonWidget)ButtonWidget.deleteButton().addId("timer-cancel");
        cancelButton.setPressable(() -> {
            if (this.timer.task().isRunning()) {
                this.timer.task().cancel();
                this.addon.pushNotification((Component)Component.translatable((String)"moneymaker.notification.timer.deleted.title", (TextColor)TextColor.color((int)255, (int)85, (int)85)), (Component)Component.translatable((String)"moneymaker.notification.timer.deleted.text", (TextColor)TextColor.color((int)170, (int)170, (int)170), (Component[])new Component[]{Component.text((String)this.timer.name(), (TextColor)TextColor.color((int)255, (int)255, (int)85))}));
            }
            Util.timers.remove(this.timer.name());
            this.addon.startActivity().reloadScreen();
        });
        this.addEntry((Widget)cancelButton);
        Component component = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)(this.timer.minutes() + "m"), (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)this.timer.remainingTime(), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)this.timer.name(), (TextColor)NamedTextColor.YELLOW));
        this.addEntry(ComponentWidget.component((Component)component).addId("timer-name"));
    }
}

