/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.commands;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.MoneyTimer;
import de.timuuuu.moneymaker.utils.Util;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.TextColor;

public class TimerCommand
extends Command {
    private int MAX_NAME_LENGTH = 32;
    private int WARNING_AMOUNT = 10;
    private boolean warningSent = false;
    private MoneyMakerAddon addon;

    public TimerCommand(MoneyMakerAddon addon) {
        super("mm-timer", new String[0]);
        this.addon = addon;
    }

    public boolean execute(String prefix, String[] arguments) {
        block12: {
            if (prefix.equalsIgnoreCase("mm-timer") && ((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).enabled().get()).booleanValue()) {
                if (this.addon.addonUtil().connectedToMoneyMaker()) {
                    if (arguments.length >= 2) {
                        try {
                            int minutes = Util.parseInteger(arguments[0], ((Object)((Object)this)).getClass());
                            StringBuilder builder = new StringBuilder();
                            for (int i = 1; i != arguments.length; ++i) {
                                builder.append(arguments[i]).append(" ");
                            }
                            String timerName = builder.toString().trim();
                            if (timerName.length() <= this.MAX_NAME_LENGTH) {
                                if (!Util.timers.containsKey(timerName)) {
                                    Util.timers.put(timerName, new MoneyTimer(timerName, minutes).start());
                                    this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.created", (TextColor)TextColor.color((int)170, (int)170, (int)170), (Component[])new Component[]{Component.text((String)timerName, (TextColor)TextColor.color((int)255, (int)255, (int)85)), Component.text((Object)minutes, (TextColor)TextColor.color((int)255, (int)255, (int)85))})));
                                    this.addon.startActivity().reloadScreen();
                                    if (Util.timers.size() > this.WARNING_AMOUNT & !this.warningSent) {
                                        this.warningSent = true;
                                        this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.performance", (TextColor)TextColor.color((int)255, (int)85, (int)85))));
                                    }
                                } else {
                                    this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.already-exists", (TextColor)TextColor.color((int)255, (int)85, (int)85))));
                                }
                                break block12;
                            }
                            this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.max-length", (TextColor)TextColor.color((int)255, (int)85, (int)85), (Component[])new Component[]{Component.text((Object)this.MAX_NAME_LENGTH)})));
                        }
                        catch (NumberFormatException ignored) {
                            this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.no-number", (TextColor)TextColor.color((int)255, (int)85, (int)85))));
                        }
                    } else {
                        this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.timer.usage", (TextColor)TextColor.color((int)255, (int)85, (int)85))));
                    }
                } else {
                    this.displayMessage(this.addon.prefix.copy().append((Component)Component.translatable((String)"moneymaker.command.notConnected", (TextColor)TextColor.color((int)255, (int)85, (int)85))));
                }
            }
        }
        return true;
    }
}

