/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget.farming;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.boosters.BoosterUtil;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.SimpleHudWidget;
import net.labymod.api.client.gui.hud.position.HudSize;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.widget.widgets.input.SliderWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.util.Color;

public class LatestBoosterDisplayWidget
extends SimpleHudWidget<BoosterHudWidgetConfig> {
    List<Booster> dummyBoosters = new ArrayList<Booster>();
    private MoneyMakerAddon addon;

    public LatestBoosterDisplayWidget(MoneyMakerAddon addon) {
        super("mm_booster_display", BoosterHudWidgetConfig.class);
        this.bindCategory(MoneyMakerAddon.CATEGORY);
        this.setIcon(Icon.sprite16((ResourceLocation)ResourceLocation.create((String)"moneymaker", (String)"themes/vanilla/textures/settings/hud/hud.png"), (int)0, (int)0));
        this.addon = addon;
        this.dummyBoosters.add(new Booster(10, 15));
        this.dummyBoosters.add(new Booster(100, 30));
        this.dummyBoosters.add(new Booster(50, 60));
    }

    public void render(SimpleHudWidget.RenderPhase renderPhase, ScreenContext screenContext, boolean isEditorContext, HudSize size) {
        size.setHeight(0.0f);
        size.setWidth(0.0f);
        if (isEditorContext) {
            this.renderBoosters(this.dummyBoosters, renderPhase, screenContext, size);
            return;
        }
        if (!this.addon.addonUtil().inFarming() && !((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get()).booleanValue()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.notConnected", (Component[])new Component[0]), renderPhase, screenContext, size);
            return;
        }
        ArrayList<Booster> boosters = new ArrayList<Booster>();
        for (int j = Booster.latestFoundBoosters().size() - 1; j >= 0; --j) {
            Booster booster = Booster.latestFoundBoosters().get(j);
            boosters.add(booster);
        }
        if (Booster.latestFoundBoosters().isEmpty()) {
            this.renderComponent((Component)Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.noBoosters", (Component[])new Component[0]), renderPhase, screenContext, size);
            return;
        }
        this.renderBoosters(boosters, renderPhase, screenContext, size);
    }

    private void renderComponent(Component component, SimpleHudWidget.RenderPhase phase, ScreenContext screenContext, HudSize size) {
        RenderableComponent renderableComponent = RenderableComponent.of((Component)component);
        if (phase.canRender()) {
            screenContext.canvas().submitRenderableComponent(renderableComponent, 1.0f, 1.0f, -1, 1);
        }
        size.setWidth(renderableComponent.getWidth() + 2.0f);
        size.setHeight(renderableComponent.getHeight() + 2.0f);
    }

    private void renderBoosters(List<Booster> boosters, SimpleHudWidget.RenderPhase phase, ScreenContext screenContext, HudSize size) {
        int x = 1;
        int y = 1;
        TranslatableComponent title = Component.translatable((String)"moneymaker.hudWidget.mm_booster_display.latestBoosters", (TextColor)TextColor.color((int)((Color)((BoosterHudWidgetConfig)this.config).textColor.get()).get()));
        RenderableComponent titleComponent = RenderableComponent.of((Component)title);
        if (phase.canRender()) {
            screenContext.canvas().submitRenderableComponent(titleComponent, (float)x, (float)y, -1, 1);
        }
        size.setWidth((float)x + titleComponent.getWidth() + 1.0f);
        y += (int)(titleComponent.getHeight() + 1.0f);
        int rowHeight = (int)screenContext.canvas().getLineHeight();
        int maxBoosterIndex = (Integer)((BoosterHudWidgetConfig)this.config).maxDisplayedBoosters.get() - 1;
        int boosterIndex = 0;
        for (Booster booster : boosters) {
            if (boosterIndex > maxBoosterIndex) break;
            ++boosterIndex;
            int boosterX = x;
            if (phase.canRender()) {
                screenContext.canvas().submitIcon(BoosterUtil.getIcon(booster), (float)boosterX, (float)y, (float)rowHeight, (float)rowHeight);
            }
            boosterX += rowHeight + 4;
            Component component = ((TextComponent)Component.text((String)(booster.boost() + "%"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)" \u2503 ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)booster.readableTime(), (TextColor)NamedTextColor.GRAY));
            RenderableComponent boosterName = RenderableComponent.of((Component)component);
            if (phase.canRender()) {
                screenContext.canvas().submitRenderableComponent(boosterName, (float)boosterX, (float)y, -1, 1);
            }
            y += (int)(boosterName.getHeight() + 1.0f);
            size.setWidth(Math.max(size.getActualWidth(), (float)((boosterX += (int)boosterName.getWidth()) + 1)));
        }
        size.setHeight((float)y);
    }

    public boolean isVisibleInGame() {
        return (this.addon.addonUtil().inFarming() || (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() != false) && !Booster.latestFoundBoosters().isEmpty();
    }

    public static class BoosterHudWidgetConfig
    extends HudWidgetConfig {
        @ColorPickerWidget.ColorPickerSetting
        private final ConfigProperty<Color> textColor = new ConfigProperty((Object)Color.YELLOW);
        @SliderWidget.SliderSetting(min=2.0f, max=10.0f)
        private final ConfigProperty<Integer> maxDisplayedBoosters = new ConfigProperty((Object)5);
    }
}

