/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.hudwidget.farming;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.Util;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidget;
import net.labymod.api.client.gui.hud.hudwidget.text.TextHudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.text.TextLine;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;

@SpriteSlot(x=3)
public class SwordStatsWidget
extends TextHudWidget<SwordHudWidgetConfig> {
    private MoneyMakerAddon addon;
    private TextLine rankLine;
    private TextLine mobsLine;

    public SwordStatsWidget(MoneyMakerAddon addon) {
        super("mm_sword_stats", SwordHudWidgetConfig.class);
        this.addon = addon;
        this.bindCategory(MoneyMakerAddon.CATEGORY);
    }

    public void load(SwordHudWidgetConfig config) {
        super.load((TextHudWidgetConfig)config);
        this.rankLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_sword_stats.display.rank", (Component[])new Component[0]), "0");
        this.mobsLine = this.createLine((Component)Component.translatable((String)"moneymaker.hudWidget.mm_sword_stats.display.kills", (Component[])new Component[0]), "0");
        this.updateLines();
    }

    public void onTick(boolean isEditorContext) {
        this.updateLines();
    }

    private void updateLines() {
        Object additional = "";
        if (((Boolean)((SwordHudWidgetConfig)this.getConfig()).showRankingDifference().get()).booleanValue() && this.addon.addonUtil().savedSwordRanking() != 0) {
            int diff = this.addon.addonUtil().savedSwordRanking() - this.addon.addonUtil().swordRanking();
            additional = " (" + (diff == 0 ? "" : (diff > 0 ? "\u2191 " : "\u2193 ")) + diff + ")";
        }
        this.rankLine.updateAndFlush((Object)(Util.format(this.addon.addonUtil().swordRanking()) + (String)additional));
        this.rankLine.setState((this.addon.addonUtil().inFarming() || (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() != false) && this.addon.addonUtil().swordRanking() != 0 ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
        this.mobsLine.updateAndFlush((Object)Util.format(this.addon.addonUtil().swordMobs()));
        this.mobsLine.setState((this.addon.addonUtil().inFarming() || (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).showWidgetsAlways().get() != false) && this.addon.addonUtil().swordMobs() != 0 ? TextLine.State.VISIBLE : TextLine.State.HIDDEN);
    }

    public static class SwordHudWidgetConfig
    extends TextHudWidgetConfig {
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showRankingDifference = new ConfigProperty((Object)false);

        public ConfigProperty<Boolean> showRankingDifference() {
            return this.showRankingDifference;
        }
    }
}

