/*
 * Decompiled with CFR 0.152.
 */
package de.timuuuu.moneymaker.utils;

import de.timuuuu.moneymaker.MoneyMakerAddon;
import de.timuuuu.moneymaker.boosters.Booster;
import de.timuuuu.moneymaker.group.GroupService;
import de.timuuuu.moneymaker.settings.MoneyMakerConfiguration;
import de.timuuuu.moneymaker.utils.Util;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.labymod.api.thirdparty.discord.DiscordActivity;
import net.labymod.api.util.I18n;
import net.labymod.api.util.concurrent.task.Task;

public class DiscordAPI {
    private MoneyMakerAddon addon;
    private DiscordActivity saved = null;
    private boolean busy;
    private Task updaterTask;
    private final String minerUrl = "https://cdn.terramc.net/moneymaker/miner.png";
    private String imageUrl;
    private String line1 = "";
    private String line2 = "";
    private AtomicInteger mineCount = new AtomicInteger(0);
    private AtomicInteger farmingCount = new AtomicInteger(0);

    public DiscordAPI(MoneyMakerAddon addon) {
        this.addon = addon;
        this.imageUrl = GroupService.getGroup("user").getIconUrl();
    }

    public void setSaved() {
        if (this.saved != null) {
            return;
        }
        this.saved = this.addon.labyAPI().thirdPartyService().discord().getDisplayedActivity();
    }

    public void removeSaved() {
        this.saved = null;
    }

    public void removeCustom() {
        if (this.saved != null) {
            this.addon.labyAPI().thirdPartyService().discord().displayActivity(this.saved);
            return;
        }
        this.addon.labyAPI().thirdPartyService().discord().displayDefaultActivity(false);
    }

    public void update() {
        if (this.busy) {
            return;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).enabled().get()).booleanValue()) {
            return;
        }
        if (!((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).discordConfiguration.enabled().get()).booleanValue()) {
            return;
        }
        if (!this.addon.addonUtil().inMine() && !this.addon.addonUtil().inFarming()) {
            return;
        }
        this.busy = true;
        DiscordActivity current = this.addon.labyAPI().thirdPartyService().discord().getDisplayedActivity();
        DiscordActivity.Builder builder = DiscordActivity.builder((Object)this);
        if (current != null) {
            builder.start(current.getStartTime());
        }
        if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).discordConfiguration.showLocation().get()).booleanValue()) {
            builder.details(this.line1);
        } else {
            builder.details("MoneyMaker Addon v" + this.addon.addonInfo().getVersion() + (this.addon.labyAPI().labyModLoader().isAddonDevelopmentEnvironment() ? " DEV" : ""));
        }
        if (((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).discordConfiguration.showStats().get()).booleanValue()) {
            builder.state(this.line2);
        } else {
            builder.state("by MisterCore & Seelenverwandter");
        }
        builder.largeAsset(DiscordActivity.Asset.of((String)this.imageUrl, (String)("MoneyMaker Addon v" + this.addon.addonInfo().getVersion() + (this.addon.labyAPI().labyModLoader().isAddonDevelopmentEnvironment() ? " DEV" : ""))));
        this.addon.labyAPI().thirdPartyService().discord().displayActivity(builder.build());
        this.busy = false;
    }

    public void startUpdater() {
        if (this.updaterTask != null) {
            return;
        }
        this.updaterTask = Task.builder(() -> {
            if (this.addon.addonUtil().inMine()) {
                this.mineCount.getAndAdd(1);
                if (this.addon.addonUtil().group() != null && !this.imageUrl.equals(this.addon.addonUtil().group().getIconUrl())) {
                    this.imageUrl = this.addon.addonUtil().group().getIconUrl();
                }
                this.line1 = I18n.translate((String)"moneymaker.discordPresence.mine.currently", (Object[])new Object[0]) + (String)(this.addon.addonUtil().currentMine() != null && (Boolean)((MoneyMakerConfiguration)this.addon.configuration()).discordConfiguration.showDetailedLocation().get() != false ? " - " + I18n.translate((String)this.addon.addonUtil().currentMine().translation(), (Object[])new Object[0]) : "");
                if (this.mineCount.get() == 1) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.mine.balance", (Object[])new Object[0]) + (this.addon.addonUtil().balance().equals("X") ? "?" : this.addon.addonUtil().balance());
                }
                if (this.mineCount.get() == 2) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.mine.workers", (Object[])new Object[0]) + this.addon.addonUtil().workerCount();
                }
                if (this.mineCount.get() >= 3) {
                    this.mineCount.set(0);
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.mine.ranking", (Object[])new Object[0]) + this.addon.addonUtil().ranking();
                }
            }
            if (this.addon.addonUtil().inFarming()) {
                this.farmingCount.getAndAdd(1);
                if (!this.imageUrl.equals("https://cdn.terramc.net/moneymaker/miner.png")) {
                    this.imageUrl = "https://cdn.terramc.net/moneymaker/miner.png";
                }
                this.line1 = I18n.translate((String)"moneymaker.discordPresence.farming.currently", (Object[])new Object[0]) + (String)((Boolean)((MoneyMakerConfiguration)this.addon.configuration()).discordConfiguration.showDetailedLocation().get() != false ? " - " + I18n.translate((String)this.addon.addonUtil().farmingCave().translation(), (Object[])new Object[0]) : "");
                if (this.farmingCount.get() == 1) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.blocks", (Object[])new Object[0]) + Util.format(this.addon.addonUtil().currentBrokenBlocks());
                }
                if (this.farmingCount.get() == 2) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.sessionBlocks", (Object[])new Object[0]) + Util.format(this.addon.addonUtil().sessionBlocks());
                }
                if (this.farmingCount.get() == 3) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.boosters", (Object[])new Object[0]) + Util.format(Booster.sessionBoosters.get()) + " (" + Util.format(Booster.sessionBoost.get()) + "%)";
                }
                if (this.farmingCount.get() == 4) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.pickaxe.rank", (Object[])new Object[0]) + Util.format(this.addon.addonUtil().pickaxeRanking());
                }
                if (this.farmingCount.get() == 5) {
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.pickaxe.level", (Object[])new Object[0]) + Util.format(this.addon.addonUtil().pickaxeLevel());
                }
                if (this.farmingCount.get() >= 6) {
                    this.farmingCount.set(0);
                    this.line2 = I18n.translate((String)"moneymaker.discordPresence.farming.ranking", (Object[])new Object[0]) + Util.format(this.addon.addonUtil().ranking());
                }
            }
            this.update();
        }).repeat(10L, TimeUnit.SECONDS).build();
        this.updaterTask.execute();
    }

    public void cancelUpdater() {
        if (this.updaterTask == null) {
            return;
        }
        this.updaterTask.cancel();
    }
}

