/*
 * Decompiled with CFR 0.152.
 */
package io.masel.nbtviewer.core.listener;

import io.masel.nbtviewer.api.INBTApi;
import io.masel.nbtviewer.core.NBTAddon;
import io.masel.nbtviewer.core.config.NBTAddonConfiguration;
import java.util.List;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.window.Window;
import net.labymod.api.client.world.item.ItemStack;
import net.labymod.api.component.data.DataComponentContainer;
import net.labymod.api.component.data.DataComponentKey;
import net.labymod.api.component.data.NbtDataComponentContainer;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.input.MouseScrollEvent;
import net.labymod.api.event.client.world.ItemStackTooltipEvent;
import net.labymod.api.nbt.tags.NBTTagCompound;
import net.labymod.api.util.Color;

@Singleton
public class ItemStackTooltipListener {
    private final Component barOpeningBracket = Component.text((String)"[").color(TextColor.color((int)Color.DARK_GRAY.get()));
    private final Component barClosingBracket = Component.text((String)"]").color(TextColor.color((int)Color.DARK_GRAY.get()));
    private final Component selectedPageIndicator = Component.text((String)"\u25ae").color(TextColor.color((int)Color.WHITE.get()));
    private final Component pageSymbol = Component.text((String)"\u00b7").color(TextColor.color((int)Color.LIGHT_GRAY.get()));
    private final NBTAddon nbtAddon;
    private final INBTApi nbtApi;
    private int tooltipPage = 0;
    private String lastTooltipId = "";

    public ItemStackTooltipListener(NBTAddon nbtAddon, INBTApi nbtApi) {
        this.nbtAddon = nbtAddon;
        this.nbtApi = nbtApi;
    }

    @Subscribe
    public void onItemStackTooltip(ItemStackTooltipEvent event) {
        String id;
        if (!this.nbtApi.hasAdvancedToolsTips()) {
            return;
        }
        if (!Laby.labyAPI().minecraft().isKeyPressed(Key.L_SHIFT)) {
            return;
        }
        ItemStack itemStack = event.itemStack();
        if (!itemStack.hasDataComponentContainer()) {
            return;
        }
        Window window = Laby.labyAPI().minecraft().minecraftWindow();
        float guiScaleFloat = window.getScale();
        int guiScale = Math.max(1, Math.round(guiScaleFloat));
        int linesPerPage = Math.max(3, 45 / guiScale);
        DataComponentContainer components = itemStack.getDataComponentContainer();
        if (((Boolean)((NBTAddonConfiguration)this.nbtAddon.configuration()).isOnlyShowCustomData().getOrDefault((Object)false)).booleanValue()) {
            DataComponentKey customDataKey = DataComponentKey.fromId((String)"minecraft", (String)"custom_data");
            if (!components.has(customDataKey)) {
                return;
            }
            components = new NbtDataComponentContainer((NBTTagCompound)components.get(customDataKey));
        }
        if (!(id = itemStack.getAsItem().getIdentifier().getNamespace() + components.hashCode()).equals(this.lastTooltipId)) {
            this.tooltipPage = 0;
            this.lastTooltipId = id;
        }
        String pretty = this.nbtApi.prettyPrint(components);
        List<String> lines = List.of(pretty.split("\n"));
        int totalPages = Math.max(1, (int)Math.ceil((double)lines.size() / (double)linesPerPage));
        this.tooltipPage = Math.min(this.tooltipPage, totalPages - 1);
        List tooltipLines = event.getTooltipLines();
        tooltipLines.add(Component.empty());
        for (int i = this.tooltipPage * linesPerPage; i < Math.min(lines.size(), (this.tooltipPage + 1) * linesPerPage); ++i) {
            tooltipLines.add(Component.text((String)lines.get(i)));
        }
        if (totalPages > 1) {
            tooltipLines.add(Component.empty());
            tooltipLines.add(this.getPageBar(totalPages));
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.text((String)("Page " + (this.tooltipPage + 1) + "/" + totalPages)).color(TextColor.color((int)Color.LIGHT_GRAY.get())));
        }
        if (((Boolean)((NBTAddonConfiguration)this.nbtAddon.configuration()).isCopy().getOrDefault((Object)false)).booleanValue()) {
            Laby.labyAPI().minecraft().setClipboard(pretty);
        }
    }

    @Subscribe
    public void onMouseScroll(MouseScrollEvent event) {
        if (!Laby.labyAPI().minecraft().isKeyPressed(Key.L_SHIFT) || !Laby.labyAPI().minecraft().minecraftWindow().isScreenOpened()) {
            return;
        }
        event.setCancelled(true);
        double scrollDelta = event.delta();
        if (scrollDelta < 0.0) {
            ++this.tooltipPage;
            return;
        }
        if (scrollDelta <= 0.0 || this.tooltipPage <= 0) {
            return;
        }
        --this.tooltipPage;
    }

    private Component getPageBar(int totalPages) {
        Component bar = this.barOpeningBracket.copy();
        for (int i = 0; i < totalPages; ++i) {
            if (i == this.tooltipPage) {
                bar.append(this.selectedPageIndicator);
                continue;
            }
            bar.append(this.pageSymbol);
        }
        return bar.append(this.barClosingBracket);
    }
}

