/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.launch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.labymod.addons.optifine.handler.OptiFineVersion;
import net.labymod.addons.optifine.launch.Patcher;
import net.labymod.addons.optifine.launch.patches.OptiFineShaderDownloadButtonPatcher;
import net.labymod.addons.optifine.launch.patches.OptiFineShadersPatcher;
import net.labymod.addons.optifine.launch.patches.OptiFineTransformerPatcher;
import net.labymod.addons.optifine.launch.patches.OptiFineWidgetIdentifierPatcher;
import net.labymod.addons.optifine.util.PatchApplierClassEntryTransformer;
import net.labymod.api.util.io.IOUtil;
import net.labymod.api.util.io.zip.EntryTransformer;
import net.labymod.api.util.io.zip.ZipTransformer;
import net.labymod.api.util.logging.Logging;

public class OptiFinePatcher {
    private static final Logging LOGGER = Logging.getLogger();
    private static final int UNKNOWN_VERSION = 0;
    private static final int VERSION = 2;
    private static final int MAX_TRIES = 3;
    private final Map<String, List<Patcher>> patchers = new HashMap<String, List<Patcher>>();
    private int tries;

    public OptiFinePatcher() {
        this.registerPatcher("optifine/OptiFineClassTransformer", new OptiFineTransformerPatcher());
        this.registerPatcher("net/optifine/shaders/gui/GuiButtonDownloadShaders", new OptiFineShaderDownloadButtonPatcher());
        this.registerPatcher("net/optifine/gui/GuiButtonOF", new OptiFineWidgetIdentifierPatcher());
        this.registerPatcher("net/optifine/shaders/Shaders", new OptiFineShadersPatcher());
    }

    public void registerPatcher(String className, Patcher patcher) {
        this.patchers.computeIfAbsent(className, l -> new ArrayList()).add(patcher);
    }

    public Map<String, List<Patcher>> getPatchers() {
        return this.patchers;
    }

    public Path patch(OptiFineVersion optiFineVersion, Path path) throws IOException {
        boolean needsTransformation;
        Path directory = path.getParent();
        Path patchedJar = directory.resolve(optiFineVersion.getQualifiedJarName() + "-PATCHED.jar");
        Path versionPath = directory.resolve(optiFineVersion.getQualifiedJarName() + ".version");
        int currentVersion = this.getVersion(versionPath);
        boolean bl = needsTransformation = currentVersion < 2;
        if (IOUtil.isCorrupted((Path)patchedJar) || needsTransformation) {
            LOGGER.info((CharSequence)("Patching " + String.valueOf(patchedJar)), new Object[0]);
            ZipTransformer transformer = ZipTransformer.createDefault((Path)path, (Path)patchedJar);
            transformer.addTransformer((EntryTransformer)new PatchApplierClassEntryTransformer(this));
            transformer.transform();
            try {
                Files.writeString(versionPath, (CharSequence)String.valueOf(2), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.info((CharSequence)("Patched " + String.valueOf(patchedJar)), new Object[0]);
        }
        if (IOUtil.isCorrupted((Path)patchedJar)) {
            ++this.tries;
            if (this.tries > 3) {
                throw new IOException("Too many tries");
            }
            LOGGER.warn((CharSequence)"Failed to patch {} (Tries: {}/{})", new Object[]{patchedJar, this.tries, 3});
            return this.patch(optiFineVersion, patchedJar);
        }
        return patchedJar;
    }

    private int getVersion(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return 0;
        }
        try {
            return Integer.parseInt(Files.readString(file));
        }
        catch (IOException | NumberFormatException exception) {
            return 0;
        }
    }
}

