/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.client.gfx.renderer.shadow;

import net.labymod.addons.optifine.client.gfx.renderer.shader.ShaderAccessor;
import net.labymod.api.client.gfx.pipeline.renderer.shadow.ShadowRenderPassContext;
import net.labymod.api.util.math.vector.FloatMatrix4;
import org.jetbrains.annotations.Nullable;

public class OptiFineShadowRenderPassContext
implements ShadowRenderPassContext {
    private static final FloatMatrix4 SHADOW_MODEL_VIEW_MATRIX = FloatMatrix4.newIdentity();
    private static final FloatMatrix4 SHADOW_MODEL_VIEW_INVERSE_MATRIX = FloatMatrix4.newIdentity();
    private static final FloatMatrix4 SHADOW_PROJECTION_MATRIX = FloatMatrix4.newIdentity();
    private static final FloatMatrix4 SHADOW_PROJECTION_INVERSE_MATRIX = FloatMatrix4.newIdentity();
    private final ShaderAccessor shaderAccessor;

    public OptiFineShadowRenderPassContext(ShaderAccessor shaderAccessor) {
        this.shaderAccessor = shaderAccessor;
    }

    public boolean isShadowRenderPass() {
        return this.shaderAccessor.isShadowPass();
    }

    @Nullable
    public FloatMatrix4 getShadowModelViewMatrix() {
        SHADOW_MODEL_VIEW_MATRIX.identity();
        SHADOW_MODEL_VIEW_MATRIX.load(this.shaderAccessor.getShadowModelViewBuffer());
        return SHADOW_MODEL_VIEW_MATRIX;
    }

    @Nullable
    public FloatMatrix4 getShadowModelViewInverseMatrix() {
        SHADOW_MODEL_VIEW_INVERSE_MATRIX.identity();
        SHADOW_MODEL_VIEW_INVERSE_MATRIX.load(this.shaderAccessor.getShadowModelViewInverseBuffer());
        return SHADOW_MODEL_VIEW_INVERSE_MATRIX;
    }

    @Nullable
    public FloatMatrix4 getShadowProjectionMatrix() {
        SHADOW_PROJECTION_MATRIX.identity();
        SHADOW_PROJECTION_MATRIX.load(this.shaderAccessor.getShadowProjectionBuffer());
        return SHADOW_PROJECTION_MATRIX;
    }

    @Nullable
    public FloatMatrix4 getShadowProjectionInverseMatrix() {
        SHADOW_PROJECTION_INVERSE_MATRIX.identity();
        SHADOW_PROJECTION_INVERSE_MATRIX.load(this.shaderAccessor.getShadowProjectionInverseBuffer());
        return SHADOW_PROJECTION_INVERSE_MATRIX;
    }
}

