/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.labymod.addons.optifine.client.gfx.renderer.shadow.OptiFineShadowRenderPassContext;
import net.labymod.addons.optifine.core.generated.DefaultReferenceStorage;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.renderer.shadow.ShadowRenderPassContext;
import net.labymod.api.client.gui.screen.widget.converter.MinecraftWidgetType;
import net.labymod.api.client.gui.screen.widget.converter.WidgetConverterRegistry;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.addon.lifecycle.AddonPostEnableEvent;
import net.labymod.api.event.client.render.shader.ShaderPipelineContextEvent;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.reference.ReferenceStorageAccessor;
import net.labymod.api.reference.ReferenceStorageFinder;
import net.labymod.api.util.logging.Logging;

@AddonMain
public class OptiFineAddon {
    private static final Logging LOGGER = Logging.getLogger();
    private static final String GUI_PACKAGE_NAME = "net.optifine.gui";
    private static final String SHADER_GUI_PACKAGE_NAME = "net.optifine.shaders.gui";
    private final Map<MinecraftWidgetType, List<String>> widgets = new HashMap<MinecraftWidgetType, List<String>>();
    private DefaultReferenceStorage referenceStorage;

    public OptiFineAddon() {
        this.registerWidgets(MinecraftWidgetType.BUTTON, GUI_PACKAGE_NAME, "GuiButtonOF", "GuiOptionButtonOF", "GuiScreenButtonOF");
        this.registerWidgets(MinecraftWidgetType.SLIDER, GUI_PACKAGE_NAME, "GuiOptionSliderOF");
        this.registerWidgets(MinecraftWidgetType.BUTTON, SHADER_GUI_PACKAGE_NAME, "GuiButtonDownloadShaders", "GuiButtonEnumShaderOption", "GuiButtonShaderOption");
        this.registerWidgets(MinecraftWidgetType.BUTTON, SHADER_GUI_PACKAGE_NAME, "GuiSliderShaderOption");
        ReferenceStorageAccessor accessor = ReferenceStorageFinder.find((ClassLoader)this.getClass().getClassLoader());
        if (accessor instanceof DefaultReferenceStorage) {
            DefaultReferenceStorage referenceStorage;
            this.referenceStorage = referenceStorage = (DefaultReferenceStorage)accessor;
        }
        if (this.referenceStorage == null) {
            LOGGER.error((CharSequence)"Failed to find reference storage accessor", new Object[0]);
        }
    }

    @Subscribe
    public void onAddonPostEnable(AddonPostEnableEvent event) {
        if (this.referenceStorage != null) {
            this.referenceStorage.screenHandler().initialize();
        }
        WidgetConverterRegistry registry = Laby.references().widgetConverterRegistry();
        this.widgets.forEach((key, classNames) -> {
            for (String className : classNames) {
                try {
                    registry.registerIfPresent(key.toString(), new Class[]{Class.forName(className)});
                }
                catch (Exception exception) {
                    if (exception instanceof ClassNotFoundException) {
                        LOGGER.warn((CharSequence)"{} could not be found!", new Object[]{className});
                        continue;
                    }
                    LOGGER.warn((CharSequence)"An error occurred during the registration of class {}", new Object[]{className, exception});
                }
            }
        });
    }

    @Subscribe
    public void onShadowRenderPassContext(ShaderPipelineContextEvent event) {
        if (this.referenceStorage != null) {
            event.setShadowRenderPassContext((ShadowRenderPassContext)new OptiFineShadowRenderPassContext(this.referenceStorage.shaderAccessor()));
        }
    }

    private void registerWidgets(MinecraftWidgetType type, String packageName, String ... classNames) {
        List names = this.widgets.computeIfAbsent(type, list -> new ArrayList(classNames.length));
        if (!((String)packageName).endsWith(".")) {
            packageName = (String)packageName + ".";
        }
        for (String string : classNames) {
            String string2 = (String)packageName + string;
            names.add(string2);
        }
    }
}

