/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.gui;

import java.util.HashMap;
import java.util.Map;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.screen.game.GameScreen;
import net.labymod.api.client.gui.screen.game.GameScreenRegistry;
import net.labymod.api.client.gui.screen.game.ScreenTags;
import net.labymod.api.client.gui.screen.game.SimpleGameScreen;
import net.labymod.api.tag.Tag;

public class OptiFineScreen {
    private static final Map<String, GameScreen> SCREENS = new HashMap<String, GameScreen>();
    public static final GameScreen ANIMATION = OptiFineScreen.createScreen("animation", true, ScreenTags.OPTIONS);
    public static final GameScreen DETAIL = OptiFineScreen.createScreen("detail", true, ScreenTags.OPTIONS);
    public static final GameScreen OTHER = OptiFineScreen.createScreen("other", true, ScreenTags.OPTIONS);
    public static final GameScreen PERFORMANCE = OptiFineScreen.createScreen("performance", true, ScreenTags.OPTIONS);
    public static final GameScreen QUALITY = OptiFineScreen.createScreen("quality", true, ScreenTags.OPTIONS);
    public static final GameScreen SHADERS = OptiFineScreen.createScreen("shaders", true, ScreenTags.OPTIONS);

    private static GameScreen createScreen(String id, boolean allowCustomFont, Tag ... tags) {
        SimpleGameScreen newScreen = new SimpleGameScreen(id, allowCustomFont, tags);
        if (SCREENS.containsKey(id)) {
            throw new IllegalStateException("Screen with id " + id + " already exists");
        }
        SCREENS.put(id, (GameScreen)newScreen);
        return newScreen;
    }

    public static void register() {
        GameScreenRegistry registry = Laby.references().gameScreenRegistry();
        for (GameScreen screen : SCREENS.values()) {
            registry.register(screen);
        }
    }
}

