/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.launch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.labymod.addons.optifine.handler.OptiFineVersion;
import net.labymod.addons.optifine.handler.OptifineDownloader;
import net.labymod.addons.optifine.launch.OptiFinePatcher;
import net.labymod.api.addon.entrypoint.Entrypoint;
import net.labymod.api.loader.platform.PlatformClassloader;
import net.labymod.api.loader.platform.PlatformEnvironment;
import net.labymod.api.models.addon.annotation.AddonEntryPoint;
import net.labymod.api.models.version.Version;
import net.labymod.api.util.io.IOUtil;
import net.labymod.api.util.version.SemanticVersion;
import net.labymod.core.loader.DefaultLabyModLoader;
import net.labymod.core.util.classpath.ClasspathUtil;

@AddonEntryPoint
public class OptiFineEntrypoint
implements Entrypoint {
    private static final Version LEGACY_VERSION = new SemanticVersion("1.16.5");
    private static URI optifineUri;
    private static Version version;

    public static URI optifineUri() {
        return optifineUri;
    }

    public static byte[] readDev(String name, ZipFile file) {
        if (file != null) {
            byte[] byArray;
            block12: {
                ZipEntry entry;
                if (version != null && version.isLowerThan(LEGACY_VERSION)) {
                    boolean addNotchPrefix = ((String)name).startsWith("net.minecraft");
                    name = ((String)name).replace(".class", "");
                    if (addNotchPrefix) {
                        name = "notch/" + ((String)name).replace(".", "/");
                    }
                    name = (String)name + ".class";
                }
                if ((entry = file.getEntry((String)name)) == null) {
                    return null;
                }
                InputStream stream = file.getInputStream(entry);
                try {
                    byArray = IOUtil.readBytes((InputStream)stream);
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        return null;
                    }
                }
                stream.close();
            }
            return byArray;
        }
        return null;
    }

    public void initialize(Version version) {
        List list;
        OptiFineEntrypoint.version = version;
        OptiFinePatcher patcher = new OptiFinePatcher();
        PlatformClassloader platformClassloader = PlatformEnvironment.getPlatformClassloader();
        OptifineDownloader optifineDownloader = new OptifineDownloader();
        try {
            optifineDownloader.download(version);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to download OptiFine jar", exception);
        }
        Path optifineJarPath = optifineDownloader.getDownloadService().getOptifineJarPath();
        if (IOUtil.isCorrupted((Path)optifineJarPath)) {
            throw new RuntimeException("OptiFine jar is corrupted");
        }
        OptiFineVersion optiFineVersion = optifineDownloader.getDownloadService().currentOptiFineVersion();
        try {
            optifineJarPath = patcher.patch(optiFineVersion, optifineJarPath);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to patch OptiFine jar", exception);
        }
        optifineUri = optifineJarPath.toUri();
        platformClassloader.addPath(optifineJarPath);
        try {
            list = ClasspathUtil.getJarEntryNames((String)optifineJarPath.toAbsolutePath().toString(), (String)"optifine");
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to read OptiFine jar entries", exception);
        }
        if (version.equals((Object)LEGACY_VERSION)) {
            platformClassloader.registerTransformer(PlatformClassloader.TransformerPhase.PRE, "net.labymod.addons.optifine.launch.transformer.GLXTransformer");
            if (!DefaultLabyModLoader.getInstance().isLabyModDevelopmentEnvironment()) {
                platformClassloader.registerTransformer(PlatformClassloader.TransformerPhase.PRE, "net.labymod.addons.optifine.launch.transformer.MixinOptiFineBufferSourceTransformer");
            }
        }
        ClassLoader classloader = platformClassloader.getPlatformClassloader();
        for (String s : list) {
            if (!s.endsWith(".class")) continue;
            s = s.replace("/", ".");
            s = s.substring(0, s.length() - ".class".length());
            try {
                classloader.loadClass(s);
            }
            catch (Throwable throwable) {}
        }
        platformClassloader.registerTransformer(PlatformClassloader.TransformerPhase.PRE, "net.labymod.addons.optifine.launch.transformer.WrappedOptiFineTransformer");
    }
}

