/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.util;

import java.util.List;
import net.labymod.addons.optifine.launch.OptiFinePatcher;
import net.labymod.addons.optifine.launch.Patcher;
import net.labymod.api.util.io.zip.EntryTransformer;
import net.labymod.api.util.io.zip.entry.ClassEntry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class PatchApplierClassEntryTransformer
extends EntryTransformer<ClassEntry> {
    private final OptiFinePatcher optiFinePatcher;

    public PatchApplierClassEntryTransformer(OptiFinePatcher optiFinePatcher) {
        super(entry -> entry instanceof ClassEntry);
        this.optiFinePatcher = optiFinePatcher;
    }

    public ClassEntry process(ClassEntry entry) {
        if (entry.getName().startsWith("srg/")) {
            return null;
        }
        String name = entry.getName().replace("notch/", "");
        String className = entry.getClassName().replace("notch/", "");
        List<Patcher> patches = this.optiFinePatcher.getPatchers().get(className);
        byte[] patchedData = entry.getData();
        if (patches != null) {
            for (Patcher patcher : patches) {
                patchedData = this.applyPatch(patchedData, patcher);
            }
        }
        return new ClassEntry(name, entry.getTime(), patchedData);
    }

    private byte[] applyPatch(byte[] classData, Patcher patcher) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(classData);
        classReader.accept((ClassVisitor)classNode, 0);
        patcher.patch(classNode);
        ClassWriter classWriter = new ClassWriter(classReader, 3);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

