/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.labymod.addons.optifine.gui.OptiFineScreen;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.screen.ScreenName;
import net.labymod.api.client.gui.screen.ScreenService;
import net.labymod.api.client.gui.screen.ScreenWrapper;
import net.labymod.api.client.gui.screen.game.GameScreen;
import net.labymod.api.reference.annotation.Referenceable;

@Referenceable
public abstract class ScreenHandler<VANILLA_SCREEN, VANILLA_OPTIONS> {
    private static final ScreenService SCREEN_SERVICE = Laby.references().screenService();
    private static final ScreenWrapper.Factory SCREEN_WRAPPER_FACTORY = Laby.references().screenWrapperFactory();

    public final void initialize() {
        OptiFineScreen.register();
        this.onInitialize();
    }

    protected abstract void onInitialize();

    public abstract void registerOptions(GameScreen var1, Class<?> var2, BiFunction<VANILLA_SCREEN, VANILLA_OPTIONS, VANILLA_SCREEN> var3);

    public void register(GameScreen screen, Class<?> screenClass, Supplier<VANILLA_SCREEN> screenFactory) {
        SCREEN_SERVICE.register(screen, ScreenName.optifine(screenClass));
        SCREEN_SERVICE.registerFactory(screen, () -> this.createScreen(screenFactory.get()));
    }

    public ScreenWrapper createScreen(VANILLA_SCREEN screen) {
        return SCREEN_WRAPPER_FACTORY.create(screen);
    }
}

