/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.handler.download;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.labymod.addons.optifine.handler.OptiFineManifest;
import net.labymod.addons.optifine.handler.OptiFineVersion;
import net.labymod.addons.optifine.handler.download.DownloadService;
import net.labymod.api.models.version.Version;
import net.labymod.api.util.io.IOUtil;

public class OptiFineDownloadService
extends DownloadService {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String USER_AGENT = "OptifineHandler";
    private static final String BASE_URL = "https://optifine.net/";
    private static final String URL_PATH = "adloadx?f=%s.jar";
    private static final String FOLLOW = "((.|\\R)+)(downloadx\\?f=%s\\.jar)([^']+)((.|\\R)+)";
    private OptiFineVersion optiFineVersion;

    @Override
    public void download(Version version) throws IOException {
        OptiFineManifest manifest;
        String gameVersion = version.toString();
        URL url = this.getClass().getClassLoader().getResource("assets/optifine/versions.json");
        if (url == null) {
            throw new IOException("OptiFine manifest file not found");
        }
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            manifest = (OptiFineManifest)GSON.fromJson((Reader)reader, OptiFineManifest.class);
        }
        catch (IOException exception) {
            throw new IOException("Failed to read OptiFine manifest file");
        }
        this.optiFineVersion = manifest.findVersion(gameVersion);
        if (this.optiFineVersion == null) {
            throw new IOException("No Optifine version was found for this specified version " + gameVersion);
        }
        this.optifineJarPath = Paths.get(String.format("labymod-neo/optifine/%s/%s.jar", gameVersion, this.optiFineVersion.getQualifiedJarName()), new String[0]);
        gameVersion = this.optiFineVersion.getQualifiedJarName();
        this.download(String.format(URL_PATH, gameVersion), String.format(FOLLOW, gameVersion.replace(".", "\\.")));
    }

    @Override
    public OptiFineVersion currentOptiFineVersion() {
        return this.optiFineVersion;
    }

    private void download(String urlPath, String follow) throws IOException {
        if (Files.exists(this.optifineJarPath, new LinkOption[0])) {
            return;
        }
        HttpURLConnection connection = this.prepareConnection(BASE_URL + urlPath);
        if (connection.getResponseCode() / 100 != 2) {
            return;
        }
        InputStream inputStream = connection.getInputStream();
        String webContent = IOUtil.toString((InputStream)inputStream);
        for (String content : webContent.split(System.lineSeparator())) {
            if (!content.matches(follow)) continue;
            int firstIndex = content.indexOf("'");
            int secondIndex = content.indexOf("'", firstIndex + 1);
            String relativeLink = content.substring(firstIndex + 1, secondIndex);
            String absoluteLink = BASE_URL + relativeLink;
            Files.createDirectories(this.optifineJarPath.getParent(), new FileAttribute[0]);
            Files.write(this.optifineJarPath, IOUtil.readBytes((InputStream)this.prepareConnection(absoluteLink).getInputStream()), new OpenOption[0]);
            break;
        }
    }

    private HttpURLConnection prepareConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(Proxy.NO_PROXY);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        return connection;
    }
}

