/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.optifine.launch.patches;

import net.labymod.addons.optifine.launch.Patcher;
import net.labymod.core.loader.DefaultLabyModLoader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class OptiFineTransformerPatcher
implements Patcher {
    private static final String NAME = "net/labymod/addons/optifine/launch/OptiFineEntrypoint";

    @Override
    public void patch(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (method.name.equals("<init>")) {
                MethodInsnNode toUriInstruction = null;
                for (AbstractInsnNode instruction : method.instructions) {
                    if (!(instruction instanceof MethodInsnNode)) continue;
                    MethodInsnNode methodNode = (MethodInsnNode)instruction;
                    if (instruction.getOpcode() != 182 || !methodNode.name.equals("toURI")) continue;
                    toUriInstruction = methodNode;
                    InsnList list = new InsnList();
                    list.insert((AbstractInsnNode)new MethodInsnNode(184, NAME, "optifineUri", "()Ljava/net/URI;"));
                    list.insert((AbstractInsnNode)new VarInsnNode(58, 2));
                    method.instructions.insert(instruction, list);
                }
                if (toUriInstruction == null) continue;
                method.instructions.insert(toUriInstruction, (AbstractInsnNode)new InsnNode(1));
                method.instructions.remove(toUriInstruction.getPrevious());
                method.instructions.remove(toUriInstruction);
                continue;
            }
            if (!DefaultLabyModLoader.getInstance().isLabyModDevelopmentEnvironment() || !method.name.equals("getOptiFineResourceZip")) continue;
            AbstractInsnNode first = method.instructions.getFirst();
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "optifine/OptiFineClassTransformer", "ofZipFile", "Ljava/util/zip/ZipFile;"));
            LabelNode labelNode = new LabelNode();
            list.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "optifine/OptiFineClassTransformer", "ofZipFile", "Ljava/util/zip/ZipFile;"));
            list.add((AbstractInsnNode)new MethodInsnNode(184, NAME, "readDev", "(Ljava/lang/String;Ljava/util/zip/ZipFile;)[B"));
            list.add((AbstractInsnNode)new InsnNode(176));
            list.add((AbstractInsnNode)labelNode);
            method.instructions.insertBefore(first, list);
        }
    }
}

