/*
 * Decompiled with CFR 0.152.
 */
package net.crazy.pingtag.core;

import net.crazy.pingtag.core.PingTagAddon;
import net.crazy.pingtag.core.PingTagConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.Entity;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.tag.tags.NameTag;
import net.labymod.api.client.network.NetworkPlayerInfo;
import net.labymod.api.client.render.font.ComponentMapper;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import org.jetbrains.annotations.Nullable;

public class PingTag
extends NameTag {
    private final PingTagAddon addon;
    private static String prePingFormat;
    private static String postPingFormat;

    public PingTag(PingTagAddon addon) {
        this.addon = addon;
        ConfigProperty<String> customFormat = ((PingTagConfiguration)addon.configuration()).getCustomFormat();
        customFormat.addChangeListener(ignored -> PingTag.updateCustomFormat(customFormat));
        PingTag.updateCustomFormat(customFormat);
    }

    @Nullable
    protected RenderableComponent getRenderableComponent() {
        Entity entity = this.entity;
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        PingTagConfiguration configuration = (PingTagConfiguration)this.addon.configuration();
        if (!((Boolean)configuration.enabled().get()).booleanValue()) {
            return null;
        }
        NetworkPlayerInfo networkPlayerInfo = player.networkPlayerInfo();
        if (networkPlayerInfo == null) {
            return null;
        }
        int ping = networkPlayerInfo.getCurrentPing();
        if (ping == 0) {
            return null;
        }
        Object format = prePingFormat;
        if (((Boolean)configuration.getColoured().get()).booleanValue()) {
            String color = ping < 150 ? "\u00a7a" : (ping < 300 ? "\u00a7c" : "\u00a74");
            format = (String)format + color;
        }
        format = (String)format + ping;
        if (postPingFormat != null) {
            format = (String)format + postPingFormat;
        }
        return RenderableComponent.of((Component)Component.text((String)format));
    }

    public float getScale() {
        return ((Float)((PingTagConfiguration)this.addon.configuration()).getScale().get()).floatValue();
    }

    public static void updateCustomFormat(ConfigProperty<String> formatProperty) {
        String format = (String)formatProperty.get();
        if (format == null || format.trim().isEmpty()) {
            format = (String)formatProperty.defaultValue();
        }
        ComponentMapper componentMapper = Laby.labyAPI().minecraft().componentMapper();
        String[] parts = componentMapper.translateColorCodes(format).split("%ping%", 2);
        prePingFormat = parts[0];
        postPingFormat = parts.length == 2 ? parts[1] : null;
    }
}

