/*
 * Decompiled with CFR 0.152.
 */
package net.crazy.pingtag.core;

import java.util.Collections;
import java.util.List;
import net.crazy.pingtag.core.PingTagAddon;
import net.crazy.pingtag.core.PingTagConfiguration;
import net.crazy.pingtag.core.snapshot.PingTagExtraKeys;
import net.crazy.pingtag.core.snapshot.PingUserSnapshot;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.render.state.entity.AvatarSnapshot;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import org.jetbrains.annotations.NotNull;

public class PingTag
extends ComponentNameTag {
    private static final LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
    private final PingTagAddon addon;
    private final PositionType registeredPosition;
    private PositionType activePosition;
    private boolean coloured;
    private String customFormat;

    public PingTag(PingTagAddon addon, PositionType registeredPosition) {
        this.addon = addon;
        this.registeredPosition = registeredPosition;
        this.activePosition = ((PingTagConfiguration.Position)((Object)((PingTagConfiguration)this.addon.configuration()).getPosition().get())).getTagPosition();
        ((PingTagConfiguration)this.addon.configuration()).getPosition().addChangeListener(position -> {
            this.activePosition = position.getTagPosition();
        });
        this.coloured = (Boolean)((PingTagConfiguration)this.addon.configuration()).getColoured().get();
        ((PingTagConfiguration)this.addon.configuration()).getColoured().addChangeListener(coloured -> {
            this.coloured = coloured;
        });
        this.customFormat = (String)((PingTagConfiguration)this.addon.configuration()).getCustomFormat().get();
        ((PingTagConfiguration)this.addon.configuration()).getCustomFormat().addChangeListener(customFormat -> {
            this.customFormat = customFormat;
        });
    }

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        AvatarSnapshot player;
        if (this.registeredPosition != this.activePosition) {
            return super.buildComponents(snapshot);
        }
        if (!(snapshot instanceof AvatarSnapshot) || (player = (AvatarSnapshot)snapshot).isDiscrete() || player.isInvisible()) {
            return super.buildComponents(snapshot);
        }
        if (!player.has(PingTagExtraKeys.PING_USER)) {
            return super.buildComponents(snapshot);
        }
        PingUserSnapshot pingUser = (PingUserSnapshot)((Object)player.get(PingTagExtraKeys.PING_USER));
        Integer ping = pingUser.getPing();
        if (ping == null) {
            return super.buildComponents(snapshot);
        }
        Component formattedPing = serializer.deserialize(this.customFormat.replace("%ping%", ping.toString()));
        if (this.coloured) {
            TextColor color = ping < 150 ? NamedTextColor.GREEN : (ping < 300 ? NamedTextColor.RED : NamedTextColor.DARK_RED);
            formattedPing.color(color);
        }
        return Collections.singletonList(formattedPing);
    }

    public float getScale() {
        return ((Float)((PingTagConfiguration)this.addon.configuration()).getScale().get()).floatValue();
    }
}

