/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.labymod.addons.resourcepacks24.core.controller.ResourcePackCategoryFeed;
import net.labymod.addons.resourcepacks24.core.controller.ResourcePackFeed;
import net.labymod.addons.resourcepacks24.core.controller.ResourcePackUglyFeed;
import net.labymod.addons.resourcepacks24.core.controller.adapter.ResourcePackTagAdapter;
import net.labymod.addons.resourcepacks24.core.controller.models.OnlineResourcePack;
import net.labymod.addons.resourcepacks24.core.util.DownloadProcess;
import net.labymod.api.util.gson.UUIDTypeAdapter;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.FileRequest;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import net.labymod.api.util.io.web.request.types.StringRequest;
import net.labymod.api.util.io.web.result.ResultCallback;

public class ResourcePacksController {
    private static final Path RESOURCEPACKS_DIRECTORY = Paths.get("resourcepacks", new String[0]);
    private static final String API_KEY = "6b514bb5-cb55-4f68-8c62-3031cf871a72";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType(), (Object)new ResourcePackTagAdapter()).create();
    private final ResourcePackFeed trendingFeed;
    private final ResourcePackFeed weekFeed;
    private final ResourcePackFeed promotedFeed;
    private final ResourcePackFeed newFeed;
    private final ResourcePackFeed randomFeed;
    private final List<ResourcePackCategoryFeed> categoryFeeds;
    private final Map<Integer, OnlineResourcePack> resourcePacks;
    private final Map<String, ResourcePackFeed> searchResults;
    private final Map<Integer, DownloadProcess> downloadProcesses;

    public ResourcePacksController() {
        String translationKey = "resourcepackstwentyfour.browse.feed";
        this.trendingFeed = new ResourcePackFeed(this, ResourcePackFeed.Type.TRENDING, translationKey, "https://resourcepacks24.de/api/feed/trending");
        this.weekFeed = new ResourcePackFeed(this, ResourcePackFeed.Type.TOP_OF_THE_WEEK, translationKey, "https://resourcepacks24.de/api/feed/resourcepack-of-the-week");
        this.promotedFeed = new ResourcePackFeed(this, ResourcePackFeed.Type.PROMOTED, translationKey, "https://resourcepacks24.de/api/feed/promotion");
        this.newFeed = new ResourcePackFeed(this, ResourcePackFeed.Type.NEW, translationKey, "https://resourcepacks24.de/api/resourcepacks/new");
        this.randomFeed = new ResourcePackUglyFeed(this, ResourcePackFeed.Type.RANDOM, translationKey, "https://resourcepacks24.de/api/resourcepacks/random");
        String categoryTranslationKey = translationKey + ".category";
        this.downloadProcesses = new HashMap<Integer, DownloadProcess>();
        this.resourcePacks = new HashMap<Integer, OnlineResourcePack>();
        this.searchResults = new HashMap<String, ResourcePackFeed>();
        this.categoryFeeds = new ArrayList<ResourcePackCategoryFeed>();
        ((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonArray.class).url("https://resourcepacks24.de/api/category/", new Object[0])).addHeader("RP24-Token", (Object)API_KEY)).async()).execute(response -> {
            if (!response.isPresent()) {
                return;
            }
            for (JsonElement jsonElement : (JsonArray)response.get()) {
                String name = jsonElement.getAsString();
                this.categoryFeeds.add(new ResourcePackCategoryFeed(this, String.format("https://resourcepacks24.de/api/category/%s", name), categoryTranslationKey, name));
            }
        });
    }

    public ResourcePackFeed trendingFeed() {
        return this.trendingFeed;
    }

    public ResourcePackFeed topOfTheWeekFeed() {
        return this.weekFeed;
    }

    public ResourcePackFeed promotedFeed() {
        return this.promotedFeed;
    }

    public ResourcePackFeed newFeed() {
        return this.newFeed;
    }

    public ResourcePackFeed randomFeed() {
        return this.randomFeed;
    }

    public List<ResourcePackCategoryFeed> getCategoryFeeds() {
        return this.categoryFeeds;
    }

    public ResourcePackFeed search(String query) {
        return this.searchResults.computeIfAbsent(query.toLowerCase().trim(), key -> new ResourcePackUglyFeed(this, ResourcePackFeed.Type.SEARCH, "resourcepackstwentyfour.browse.feed.search", String.format("https://resourcepacks24.de/api/search/%s", query)));
    }

    public void load(String url, Function<Response<JsonElement>, JsonArray> arrayProvider, Consumer<OnlineResourcePack> packConsumer, Runnable finishConsumer) {
        ((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonElement.class, () -> GSON).url(url, new Object[0])).addHeader("RP24-Token", (Object)API_KEY)).async()).execute(response -> {
            JsonArray array = (JsonArray)arrayProvider.apply((Response<JsonElement>)response);
            if (array == null) {
                return;
            }
            for (JsonElement jsonElement : array) {
                if (!jsonElement.isJsonObject()) continue;
                try {
                    JsonObject object = jsonElement.getAsJsonObject();
                    if (!object.has("rp_id") || !object.getAsJsonPrimitive("rp_id").isNumber()) continue;
                    int id = object.getAsJsonPrimitive("rp_id").getAsInt();
                    OnlineResourcePack resourcePack = this.resourcePacks.get(id);
                    if (resourcePack == null) {
                        resourcePack = (OnlineResourcePack)GSON.fromJson((JsonElement)object, OnlineResourcePack.class);
                        this.resourcePacks.put(id, resourcePack);
                    }
                    packConsumer.accept(resourcePack);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finishConsumer.run();
        });
    }

    public void download(int resourcePackId, Consumer<Double> percentageCallback, ResultCallback<DownloadProcess> callback) {
        ((StringRequest)((StringRequest)((StringRequest)Request.ofString().url("https://resourcepacks24.de/api/download/%s", new Object[]{resourcePackId})).addHeader("RP24-Token", (Object)API_KEY)).async()).execute(urlResponse -> {
            FileRequest fileRequest = Request.ofFile((Path)RESOURCEPACKS_DIRECTORY, (Consumer)percentageCallback);
            if (!urlResponse.isPresent()) {
                this.downloadProcesses.put(resourcePackId, new DownloadProcess(fileRequest));
                callback.acceptException((Exception)new IllegalStateException("Failed to download resource pack!"));
                return;
            }
            String url = (String)urlResponse.get();
            DownloadProcess downloadProcess = new DownloadProcess((FileRequest)fileRequest.url(url, new Object[0]));
            downloadProcess.start();
            this.downloadProcesses.put(resourcePackId, downloadProcess);
            callback.acceptRaw((Object)downloadProcess);
        });
    }

    public DownloadProcess getDownloadProcess(int resourcePackId) {
        return this.downloadProcesses.get(resourcePackId);
    }
}

