/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.controller.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResourcePackTagAdapter
extends TypeAdapter<List<String>> {
    private static final Gson GSON = new Gson();

    public void write(JsonWriter out, List<String> value) throws IOException {
        out.beginArray();
        for (String s : value) {
            out.value(s);
        }
        out.endArray();
    }

    public List<String> read(JsonReader reader) throws IOException {
        String string = reader.nextString();
        JsonElement element = (JsonElement)GSON.fromJson(string, JsonElement.class);
        if (!element.isJsonArray()) {
            throw new IOException("Expected tags to be a JsonArray but it is a " + element.getClass().getSimpleName());
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (JsonElement jsonElement : element.getAsJsonArray()) {
            tags.add(jsonElement.getAsString());
        }
        return tags;
    }
}

