/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.util;

import java.text.DecimalFormat;

public class FileSizeConverter {
    private static final int KB = 1000;
    private static final int MB = 1000000;
    private static final int GB = 1000000000;
    private static final int[] UNIT_THRESHOLDS = new int[]{1, 1000, 1000000, 1000000000};
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private static final String[] UNIT_SUFFIXES = new String[]{" bytes", " KB", " MB", " GB"};

    private FileSizeConverter() {
    }

    public static String convertToHumanReadableString(long bytes) {
        for (int i = UNIT_THRESHOLDS.length - 1; i >= 0; --i) {
            if (bytes < (long)UNIT_THRESHOLDS[i]) continue;
            return DECIMAL_FORMAT.format((double)bytes / (double)UNIT_THRESHOLDS[i]) + UNIT_SUFFIXES[i];
        }
        return bytes + UNIT_SUFFIXES[0];
    }
}

