/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.activity;

import net.labymod.addons.resourcepacks24.core.ResourcePacks24;
import net.labymod.addons.resourcepacks24.core.controller.ResourcePacksController;
import net.labymod.addons.resourcepacks24.core.widgets.BrowseResourcePacksWidget;
import net.labymod.api.Constants;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.AbstractLayerActivity;
import net.labymod.api.client.gui.screen.key.InputType;
import net.labymod.api.client.gui.screen.key.Key;
import net.labymod.api.client.gui.screen.key.MouseButton;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.resources.ResourceLocation;

@AutoActivity
@Link(value="resourcepack-overview.lss")
public class ResourcePacksOverlay
extends AbstractLayerActivity {
    private static final MutableMouse DUMMY_MOUSE = new MutableMouse();
    private final ResourcePacks24 resourcePacks;
    private final ResourcePacksController controller;
    private final BrowseResourcePacksWidget browseWidget;
    private DivWidget innerOverlayWrapper;
    private boolean overlayVisible;

    public ResourcePacksOverlay(ScreenInstance parentScreen, ResourcePacks24 resourcePacks, ResourcePacksController controller) {
        super(parentScreen);
        this.resourcePacks = resourcePacks;
        this.controller = controller;
        this.browseWidget = new BrowseResourcePacksWidget(resourcePacks, controller);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        ButtonWidget browseButton = ButtonWidget.i18n((String)"resourcepackstwentyfour.browse.button");
        browseButton.addId("browse-button");
        browseButton.setPressable(() -> {
            this.overlayVisible = !this.overlayVisible;
            this.reload();
        });
        ((Document)this.document).addChild((Widget)browseButton);
        if (!this.overlayVisible) {
            return;
        }
        DivWidget overlayWrapper = new DivWidget();
        overlayWrapper.addId("overlay-wrapper");
        this.innerOverlayWrapper = new DivWidget();
        this.innerOverlayWrapper.addId("inner-overlay-wrapper");
        HorizontalListWidget browseHeader = new HorizontalListWidget();
        browseHeader.addId("browse-header");
        DivWidget titleWrapper = new DivWidget();
        titleWrapper.addId("title-wrapper");
        ComponentWidget title = ComponentWidget.i18n((String)"resourcepackstwentyfour.settings.name");
        title.addId("title");
        titleWrapper.addChild((Widget)title);
        browseHeader.addEntry((Widget)titleWrapper);
        IconWidget closeButton = new IconWidget(Icon.sprite8((ResourceLocation)Constants.NamedThemeResource.COMMON, (int)2, (int)4));
        closeButton.addId("close-button");
        closeButton.setPressable(() -> {
            this.overlayVisible = false;
            this.reload();
        });
        browseHeader.addEntry((Widget)closeButton);
        this.innerOverlayWrapper.addChild((Widget)browseHeader);
        DivWidget browseWrapper = new DivWidget();
        browseWrapper.addId("browse-wrapper");
        browseWrapper.addChild((Widget)this.browseWidget);
        this.innerOverlayWrapper.addChild((Widget)browseWrapper);
        overlayWrapper.addChild((Widget)this.innerOverlayWrapper);
        ((Document)this.document).addChild((Widget)overlayWrapper);
    }

    public boolean mouseClicked(MutableMouse mouse, MouseButton mouseButton) {
        if (this.overlayVisible && this.innerOverlayWrapper != null) {
            return this.innerOverlayWrapper.mouseClicked(mouse, mouseButton);
        }
        return super.mouseClicked(mouse, mouseButton);
    }

    public void render(Stack stack, MutableMouse mouse, float partialTicks) {
        super.render(stack, mouse, partialTicks);
    }

    public boolean keyPressed(Key key, InputType type) {
        if (this.overlayVisible && key == Key.ESCAPE) {
            this.overlayVisible = false;
            this.reload();
            return true;
        }
        return super.keyPressed(key, type);
    }

    public void setParentScreen(ScreenInstance previousScreen) {
        this.parentScreen = previousScreen;
    }
}

