/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.controller.models;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.UUID;
import net.labymod.addons.resourcepacks24.core.ResourcePacks24;
import net.labymod.addons.resourcepacks24.core.controller.adapter.ResourcePackTagAdapter;
import net.labymod.addons.resourcepacks24.core.util.FileSizeConverter;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.CompletableResourceLocation;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.TextureRepository;

public class OnlineResourcePack {
    private int size;
    private String thumbnail;
    private String description;
    private String category;
    private double rating;
    private UUID creator;
    private List<Screenshot> screenshots;
    @SerializedName(value="rp_id")
    private int id;
    @SerializedName(value="website_name")
    private String onlineName;
    @SerializedName(value="ingame_name")
    private String ingameName;
    @SerializedName(value="download")
    private int downloads;
    @JsonAdapter(value=ResourcePackTagAdapter.class)
    private List<String> tags;
    @SerializedName(value="created_at")
    private String createdAt;
    @SerializedName(value="updated_at")
    private String updatedAt;
    private transient Icon icon;
    private transient Component nameComponent;
    private transient Component descriptionComponent;
    private transient Component sizeComponent;

    public int getId() {
        return this.id;
    }

    public String getOnlineName() {
        return this.onlineName;
    }

    public String getIngameName() {
        return this.ingameName;
    }

    public int getSize() {
        return this.size;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public int getDownloads() {
        return this.downloads;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public double getRating() {
        return this.rating;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<Screenshot> getScreenshots() {
        return this.screenshots;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public String getCreatedAtRaw() {
        return this.createdAt;
    }

    public String getUpdatedAtRaw() {
        return this.updatedAt;
    }

    public Icon icon() {
        if (this.icon == null) {
            this.icon = this.thumbnail == null ? Icon.texture((ResourceLocation)ResourcePacks24.FALLBACK_ICON) : Icon.url((String)this.thumbnail, (ResourceLocation)ResourcePacks24.FALLBACK_ICON);
        }
        return this.icon;
    }

    public Component name() {
        if (this.nameComponent == null) {
            String ingameName;
            if (this.ingameName == null) {
                this.ingameName = "";
            }
            if ((ingameName = this.ingameName.trim()).charAt(0) == '\u00a7' && ingameName.indexOf(32) == 3) {
                ingameName = ingameName.substring(2);
            }
            if (ingameName.startsWith("!")) {
                ingameName = ingameName.substring(1);
            }
            this.nameComponent = Component.text((String)ingameName.trim());
        }
        return this.nameComponent;
    }

    public Component description() {
        if (this.descriptionComponent == null) {
            if (this.description == null) {
                this.description = "";
            }
            this.descriptionComponent = Component.text((String)this.description);
        }
        return this.descriptionComponent;
    }

    public Component size() {
        if (this.sizeComponent == null) {
            this.sizeComponent = Component.text((String)FileSizeConverter.convertToHumanReadableString(this.size));
        }
        return this.sizeComponent;
    }

    public static class Screenshot {
        private static final TextureRepository TEXTURE_REPOSITORY = Laby.references().textureRepository();
        @SerializedName(value="image_url")
        private String url;
        private transient CompletableResourceLocation completableResourceLocation;

        public String getUrl() {
            return this.url;
        }

        public Icon getIcon() {
            if (this.url == null) {
                return null;
            }
            return Icon.completable((CompletableResourceLocation)this.getCompletableResourceLocation());
        }

        public CompletableResourceLocation getCompletableResourceLocation() {
            if (this.url == null) {
                return null;
            }
            if (this.completableResourceLocation == null) {
                this.completableResourceLocation = TEXTURE_REPOSITORY.loadCacheResourceAsync("resourcepacks24", "url/" + this.url.hashCode(), this.url, Textures.EMPTY);
            }
            return this.completableResourceLocation;
        }
    }
}

