/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.util;

import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.FileRequest;

public class DownloadProcess {
    private final FileRequest request;
    private State state;
    private Response<Path> response;
    private Consumer<DownloadProcess> callback;

    public DownloadProcess(FileRequest request) {
        this.request = request;
        this.state = State.NONE;
    }

    public void start() {
        this.setState(State.DOWNLOADING);
        this.request.execute(response -> {
            this.response = response;
            if (!response.isPresent()) {
                if (response.hasException() && response.exception().getCause() instanceof FileAlreadyExistsException) {
                    this.setState(State.FINISHED);
                } else {
                    this.setState(State.FAILED);
                }
                return;
            }
            this.setState(State.FINISHED);
        });
    }

    public State state() {
        return this.state;
    }

    public Response<Path> getResponse() {
        return this.response;
    }

    public void setCallback(Consumer<DownloadProcess> callback) {
        this.callback = callback;
    }

    private void setState(State state) {
        this.state = state;
        if (this.callback != null) {
            this.callback.accept(this);
        }
    }

    public static enum State {
        NONE,
        DOWNLOADING,
        FINISHED,
        FAILED;

    }
}

