/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.util.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.labymod.addons.resourcepacks24.core.util.callback.CachedCallback;
import net.labymod.addons.resourcepacks24.core.util.callback.CachedMultitonCallback;
import net.labymod.addons.resourcepacks24.core.util.callback.CachedSingletonCallback;

public class CachedCallbackCollection<C extends Consumer> {
    private final List<CachedCallback<C>> callbacks = new ArrayList<CachedCallback<C>>();

    private CachedCallbackCollection() {
    }

    public static <C extends Consumer> CachedCallbackCollection<C> create() {
        return new CachedCallbackCollection<C>();
    }

    public boolean addSingleton(Object identifier, C callback) {
        String identifierString = identifier.toString();
        CachedCallback<C> cachedCallback = this.get(identifierString);
        if (cachedCallback == null) {
            this.callbacks.add(new CachedSingletonCallback<C>(identifierString, callback));
            return false;
        }
        if (!(cachedCallback instanceof CachedSingletonCallback)) {
            throw new IllegalStateException("Callback with identifier " + identifierString + " is not a singleton");
        }
        cachedCallback.add(callback);
        return true;
    }

    public boolean addMultiton(Object identifier, C callback) {
        String identifierString = identifier.toString();
        CachedCallback<C> cachedCallback = this.get(identifierString);
        if (cachedCallback == null) {
            this.callbacks.add(new CachedMultitonCallback<C>(identifierString, callback));
            return false;
        }
        if (!(cachedCallback instanceof CachedMultitonCallback)) {
            throw new IllegalStateException("Callback with identifier " + identifierString + " is not a multiton");
        }
        cachedCallback.add(callback);
        return true;
    }

    public <T> void fire(Object identifier, T value) {
        String identifierString = identifier.toString();
        CachedCallback<C> cachedCallback = this.get(identifierString);
        if (cachedCallback == null) {
            return;
        }
        cachedCallback.fire(value);
        this.callbacks.remove(cachedCallback);
    }

    private CachedCallback<C> get(String identifier) {
        for (CachedCallback<C> callback : this.callbacks) {
            if (!callback.getIdentifier().equals(identifier)) continue;
            return callback;
        }
        return null;
    }
}

