/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.widgets;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.labymod.api.client.gui.lss.property.LssProperty;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.action.ListSession;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.TilesGridWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.ListWidget;

@AutoWidget
public class GridFeedWidget<T extends Widget>
extends TilesGridWidget<T> {
    private final BiPredicate<GridFeedWidget<T>, Consumer<T>> refresh;
    private final ListSession<T> session;
    private final LssProperty<Float> refreshRadius = new LssProperty((Object)Float.valueOf(-1.0f));
    private boolean doRefresh = true;

    public GridFeedWidget(BiPredicate<GridFeedWidget<T>, Consumer<T>> refresh, ListSession<T> session) {
        this.refresh = refresh;
        this.session = session;
    }

    public GridFeedWidget(BiPredicate<GridFeedWidget<T>, Consumer<T>> refresh) {
        this(refresh, new ListSession());
    }

    public void updateVisibility(ListWidget<?> list, Parent parent) {
        super.updateVisibility(list, parent);
        if (!(parent instanceof ScrollWidget)) {
            return;
        }
        Bounds parentBounds = parent.bounds();
        if (this.doRefresh && this.bounds().getHeight() > 0.0f) {
            float f = this.session.getScrollPositionY();
            float f2 = this.bounds().getHeight() - parentBounds.getHeight();
            float f3 = this.refreshRadius.isDefaultValue() ? this.getTileHeight() * 2.0f : ((Float)this.refreshRadius.get()).floatValue();
            if (f >= f2 - f3) {
                this.doRefresh = false;
                boolean update = this.refresh.test(this, arg_0 -> ((GridFeedWidget)this).addTileInitialized(arg_0));
                if (update) {
                    this.updateTiles();
                    this.doRefresh = true;
                }
            }
        }
    }

    public LssProperty<Float> refreshRadius() {
        return this.refreshRadius;
    }

    public ListSession<T> getSession() {
        return this.session;
    }

    public void doRefresh(boolean doRefresh) {
        this.doRefresh = doRefresh;
    }
}

