/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.resourcepacks24.core.widgets;

import java.util.List;
import net.labymod.addons.resourcepacks24.core.controller.ResourcePacksController;
import net.labymod.addons.resourcepacks24.core.controller.models.OnlineResourcePack;
import net.labymod.addons.resourcepacks24.core.util.DownloadProcess;
import net.labymod.addons.resourcepacks24.core.util.FileSizeConverter;
import net.labymod.addons.resourcepacks24.core.widgets.MiscWidget;
import net.labymod.api.Constants;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.lss.style.modifier.attribute.AttributeState;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.AbstractWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.RatingWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.resources.CompletableResourceLocation;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.util.io.web.result.ResultCallback;

@AutoWidget
public class ResourcePackInfoWidget
extends AbstractWidget<Widget> {
    private final OnlineResourcePack resourcePack;
    private final ResourcePacksController controller;
    private final Runnable backRunnable;
    private DownloadProcess process;

    public ResourcePackInfoWidget(OnlineResourcePack resourcePack, ResourcePacksController controller, DownloadProcess process, Runnable backRunnable) {
        this.resourcePack = resourcePack;
        this.controller = controller;
        this.process = process;
        this.backRunnable = backRunnable;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.children.clear();
        VerticalListWidget container = new VerticalListWidget();
        container.addId("container");
        DivWidget detailsContainer = new DivWidget();
        detailsContainer.addId("details-container");
        IconWidget iconWidget = new IconWidget(this.resourcePack.icon());
        iconWidget.addId("icon");
        detailsContainer.addChild((Widget)iconWidget);
        DivWidget detailsInfoWrapper = new DivWidget();
        detailsInfoWrapper.addId("details-info-wrapper");
        VerticalListWidget detailsInfoContainer = new VerticalListWidget();
        detailsInfoContainer.addId("details-info-container");
        ComponentWidget nameWidget = ComponentWidget.component((Component)this.resourcePack.name());
        nameWidget.addId("name");
        detailsInfoContainer.addChild((Widget)nameWidget);
        RatingWidget ratingWidget = new RatingWidget(this.resourcePack.getRating());
        ratingWidget.addId("rating");
        detailsInfoContainer.addChild((Widget)ratingWidget);
        detailsInfoWrapper.addChild((Widget)detailsInfoContainer);
        detailsContainer.addChild((Widget)detailsInfoWrapper);
        container.addChild((Widget)detailsContainer);
        HorizontalListWidget miscContainer = new HorizontalListWidget();
        miscContainer.addId("misc-container");
        miscContainer.addEntry(new MiscWidget(Icon.sprite32((ResourceLocation)Constants.NamedThemeResource.FLINT, (int)0, (int)1), "labymod.addons.store.profile.downloads", String.format("%,d", this.resourcePack.getDownloads())).addId("downloads"));
        miscContainer.addEntry(new MiscWidget(Icon.sprite32((ResourceLocation)Constants.NamedThemeResource.FLINT, (int)2, (int)1), "Size", FileSizeConverter.convertToHumanReadableString(this.resourcePack.getSize())).addId("size"));
        miscContainer.addEntry(new MiscWidget(Icon.sprite32((ResourceLocation)Constants.NamedThemeResource.FLINT, (int)3, (int)1), "Category", this.resourcePack.getCategory().toUpperCase()).addId("category"));
        container.addChild((Widget)miscContainer);
        ComponentWidget descriptionTitleWidget = ComponentWidget.text((String)"Description");
        descriptionTitleWidget.addId("description-title");
        container.addChild((Widget)descriptionTitleWidget);
        ComponentWidget descriptionWidget = ComponentWidget.component((Component)this.resourcePack.description());
        descriptionWidget.addId("description");
        container.addChild((Widget)descriptionWidget);
        List<OnlineResourcePack.Screenshot> screenshots = this.resourcePack.getScreenshots();
        if (!screenshots.isEmpty()) {
            ComponentWidget screenshotsTitleWidget = ComponentWidget.text((String)"Screenshots");
            screenshotsTitleWidget.addId("screenshots-title");
            container.addChild((Widget)screenshotsTitleWidget);
            VerticalListWidget screenshotsContainer = new VerticalListWidget();
            screenshotsContainer.addId("screenshots-container");
            for (OnlineResourcePack.Screenshot screenshot : screenshots) {
                CompletableResourceLocation resourceLocation = screenshot.getCompletableResourceLocation();
                if (resourceLocation == null) continue;
                IconWidget screenshotWidget = new IconWidget(Icon.completable((CompletableResourceLocation)resourceLocation));
                screenshotWidget.addId("screenshot");
                if (!resourceLocation.hasResult()) {
                    resourceLocation.addCompletableListener(() -> screenshotWidget.setVisible(resourceLocation.hasResult()));
                }
                screenshotsContainer.addChild((Widget)screenshotWidget);
            }
            container.addChild((Widget)screenshotsContainer);
        }
        this.addChild((Widget)new ScrollWidget(container));
        DivWidget topContainer = new DivWidget();
        topContainer.addId("top-container");
        ButtonWidget backButton = ButtonWidget.icon((Icon)Icon.sprite8((ResourceLocation)Constants.NamedThemeResource.COMMON, (int)4, (int)4));
        backButton.addId("back-button");
        backButton.setPressable(this.backRunnable::run);
        topContainer.addChild((Widget)backButton);
        ButtonWidget downloadButton = ButtonWidget.text((String)"");
        downloadButton.addId("download-button");
        this.updateDownloadButton(downloadButton);
        downloadButton.setPressable(() -> {
            if (!downloadButton.isAttributeStateEnabled(AttributeState.ENABLED)) {
                return;
            }
            downloadButton.setEnabled(false);
            if (this.process == null) {
                this.controller.download(this.resourcePack.getId(), progress -> this.labyAPI.minecraft().executeOnRenderThread(() -> downloadButton.updateComponent((Component)Component.text((String)(progress.intValue() + "%")))), (ResultCallback<DownloadProcess>)((ResultCallback)result -> this.labyAPI.minecraft().executeOnRenderThread(() -> {
                    if (result.hasException()) {
                        Throwable cause = result.exception().getCause();
                        System.out.println("Failed to download resource pack: " + cause);
                        downloadButton.updateComponent((Component)Component.text((String)"Failed!"));
                        return;
                    }
                    this.process = (DownloadProcess)result.get();
                    this.process.setCallback(process -> this.updateDownloadButton(downloadButton));
                    this.updateDownloadButton(downloadButton);
                })));
            } else if (this.process.state() == DownloadProcess.State.NONE) {
                this.process.start();
                this.process.setCallback(process -> this.labyAPI.minecraft().executeOnRenderThread(() -> this.updateDownloadButton(downloadButton)));
                this.updateDownloadButton(downloadButton);
            }
        });
        topContainer.addChild((Widget)downloadButton);
        this.addChild((Widget)topContainer);
    }

    private void updateDownloadButton(ButtonWidget buttonWidget) {
        if (this.process != null) {
            boolean enabled = true;
            switch (this.process.state()) {
                case DOWNLOADING: {
                    enabled = false;
                    buttonWidget.updateComponent((Component)Component.text((String)"Downloading..."));
                    break;
                }
                case FAILED: {
                    enabled = false;
                    buttonWidget.updateComponent((Component)Component.text((String)"Failed!"));
                    break;
                }
                case FINISHED: {
                    enabled = false;
                    buttonWidget.updateComponent((Component)Component.text((String)"Finished"));
                }
            }
            buttonWidget.setEnabled(enabled);
            return;
        }
        buttonWidget.updateComponent((Component)Component.text((String)"Download"));
    }

    private void download(DownloadProcess process) {
    }

    public OnlineResourcePack resourcePack() {
        return this.resourcePack;
    }
}

