/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.screenshotuploader.core.command;

import com.rappytv.screenshotuploader.core.ScreenshotUploaderAddon;
import com.rappytv.screenshotuploader.core.config.UploaderConfig;
import com.rappytv.screenshotuploader.core.ui.activity.UploadActivity;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.gui.screen.ScreenInstance;

public class UploadCommand
extends Command {
    private final ScreenshotUploaderAddon addon;
    private final Set<String> history = new HashSet<String>();

    public UploadCommand(ScreenshotUploaderAddon addon) {
        super("supload", new String[0]);
        this.addon = addon;
        this.translationKey("screenshotuploader.command");
    }

    public boolean execute(String prefix, String[] args) {
        if (args.length < 1) {
            this.displayMessage(ScreenshotUploaderAddon.prefix().append((Component)Component.translatable((String)this.getTranslationKey("fileNotFound"), (TextColor)NamedTextColor.RED)));
            return true;
        }
        File file = new File(System.getProperty("user.dir") + "/screenshots/" + args[0]);
        if (!file.exists()) {
            this.displayMessage(ScreenshotUploaderAddon.prefix().append((Component)Component.translatable((String)this.getTranslationKey("fileNotFound"), (TextColor)NamedTextColor.RED)));
            return true;
        }
        if (this.history.contains(file.getName()) && ((Boolean)((UploaderConfig)this.addon.configuration()).askBeforeDoubleUploads().get()).booleanValue() && (args.length < 2 || !args[1].equalsIgnoreCase("force"))) {
            Component component = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(ScreenshotUploaderAddon.prefix())).append((Component)Component.translatable((String)this.getTranslationKey("alreadyUploaded"), (TextColor)NamedTextColor.RED))).append((Component)Component.space())).append(((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)this.getTranslationKey("openAnyway"), (Component[])new Component[0]).color(NamedTextColor.AQUA)).decorate(TextDecoration.UNDERLINED)).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)this.getTranslationKey("uploadFile"), (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{Component.text((String)file.getName())})))).clickEvent(ClickEvent.runCommand((String)String.format("/%s %s force", prefix, file.getName()))));
            this.displayMessage(component);
            return true;
        }
        this.history.add(file.getName());
        Laby.labyAPI().minecraft().executeOnRenderThread(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new UploadActivity(file)));
        return true;
    }
}

