/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.screenshotuploader.core.ui.widget;

import com.rappytv.screenshotuploader.api.UploadException;
import com.rappytv.screenshotuploader.api.Uploader;
import com.rappytv.screenshotuploader.core.ScreenshotUploaderAddon;
import java.io.File;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.concurrent.task.Task;

@AutoWidget
public class UploaderWidget
extends HorizontalListWidget {
    private final Uploader<?> uploader;
    private final File file;

    public UploaderWidget(Uploader<?> uploader, File file) {
        this.uploader = uploader;
        this.file = file;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        IconWidget icon = (IconWidget)new IconWidget(this.uploader.getIcon()).addId("icon");
        ComponentWidget name = (ComponentWidget)ComponentWidget.text((String)this.uploader.getName()).addId("name");
        ButtonWidget button = (ButtonWidget)ButtonWidget.i18n((String)"screenshotuploader.activity.upload").addId("button");
        if (!this.uploader.validateConfig()) {
            button.setEnabled(false);
            button.setHoverComponent((Component)Component.translatable((String)"screenshotuploader.activity.invalidConfig", (TextColor)NamedTextColor.RED));
        }
        button.setActionListener(() -> {
            button.setEnabled(false);
            button.setHoverComponent(null);
            button.updateComponent((Component)Component.translatable((String)"screenshotuploader.activity.uploading", (TextColor)NamedTextColor.AQUA));
            Task.builder(() -> {
                try {
                    String url = this.uploader.uploadScreenshot(this.file);
                    Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
                        button.setEnabled(true);
                        button.updateComponent((Component)Component.translatable((String)"screenshotuploader.activity.copy", (TextColor)NamedTextColor.GREEN));
                    });
                    Laby.labyAPI().notificationController().push(Notification.builder().title((Component)Component.translatable((String)"screenshotuploader.notification.success", (Component[])new Component[0])).text((Component)Component.translatable((String)"screenshotuploader.activity.uploaded", (Component[])new Component[]{Component.text((String)this.uploader.getName())})).build());
                    button.setActionListener(() -> {
                        Laby.labyAPI().notificationController().push(Notification.builder().title((Component)Component.translatable((String)"screenshotuploader.notification.success", (Component[])new Component[0])).text((Component)Component.translatable((String)"screenshotuploader.activity.copied", (Component[])new Component[0])).build());
                        if (!url.isBlank()) {
                            Laby.labyAPI().minecraft().chatExecutor().copyToClipboard(url);
                        }
                    });
                }
                catch (UploadException e) {
                    button.setHoverComponent((Component)Component.text((String)e.getMessage(), (TextColor)NamedTextColor.RED));
                    ScreenshotUploaderAddon.logging().error((CharSequence)("Failed to upload screenshot to " + e.getUploader().getName()), (Throwable)e);
                    Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
                        button.setEnabled(true);
                        button.updateComponent((Component)Component.translatable((String)"screenshotuploader.activity.error", (TextColor)NamedTextColor.RED));
                    });
                    Laby.labyAPI().notificationController().push(Notification.builder().title((Component)Component.translatable((String)"screenshotuploader.notification.error", (Component[])new Component[0])).text((Component)Component.translatable((String)"screenshotuploader.activity.checkTheLog", (Component[])new Component[0])).build());
                }
            }).build().execute();
        });
        this.addEntry((Widget)icon);
        this.addEntry((Widget)name);
        this.addEntry((Widget)button);
    }

    public Uploader<?> getUploader() {
        return this.uploader;
    }

    public int getSortingValue() {
        return 1;
    }
}

