/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.screenshotuploader.core.uploader.uploaders;

import com.google.gson.JsonObject;
import com.rappytv.screenshotuploader.api.ScreenshotUploaderTextures;
import com.rappytv.screenshotuploader.api.UploadException;
import com.rappytv.screenshotuploader.api.Uploader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.network.server.ServerData;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.TokenStorage;
import net.labymod.api.util.io.web.request.FormData;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftShotUploader
extends Uploader<Uploader.EmptyConfig> {
    private static final String UPLOAD_ENDPOINT = "https://craftshot.net/v1/upload";

    public CraftShotUploader() {
        super("craftshot", "CraftShot");
    }

    @Override
    public Icon getIcon() {
        return ScreenshotUploaderTextures.SpriteUploaders.CRAFTSHOT;
    }

    @Override
    @NotNull
    public Uploader.EmptyConfig getConfig() {
        return EMPTY_CONFIG;
    }

    @Override
    public boolean validateConfig() {
        return true;
    }

    @Override
    public String uploadScreenshot(File file) throws UploadException {
        String token = this.getLabyConnectToken();
        if (token == null) {
            throw new UploadException("You're not connected to LabyConnect!", this);
        }
        ArrayList<FormData> formData = new ArrayList<FormData>();
        formData.add(FormData.builder().name("access_token").value(token).build());
        String host = this.getHost();
        if (host != null) {
            formData.add(FormData.builder().name("server_ip").value(host).build());
        }
        try {
            formData.add(FormData.builder().name("screenshot").fileName("screenshot.png").contentType("image/png").value(file.toPath()).build());
        }
        catch (IOException e) {
            throw new UploadException(e, this);
        }
        Response response = ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url(UPLOAD_ENDPOINT, new Object[0])).method(Request.Method.POST)).form(formData)).handleErrorStream()).executeSync();
        if (response.hasException()) {
            throw new UploadException((Throwable)response.exception(), this);
        }
        try {
            int statusCode = response.getStatusCode();
            JsonObject data = ((JsonObject)response.get()).get("data").getAsJsonObject();
            if (statusCode != 200) {
                if (data != null && data.has("message")) {
                    throw new UploadException(data.get("message").getAsString(), this);
                }
                throw new UploadException("Failed to upload file with status " + statusCode, this);
            }
            if (data != null && data.has("url")) {
                return data.get("url").getAsString();
            }
            throw new UploadException("Response body does not contain the file link", this);
        }
        catch (IllegalArgumentException e) {
            throw new UploadException(e, this);
        }
    }

    @Nullable
    private String getLabyConnectToken() {
        LabyConnectSession session = Laby.labyAPI().labyConnect().getSession();
        if (session == null) {
            return null;
        }
        TokenStorage.Token token = session.tokenStorage().getToken(TokenStorage.Purpose.JWT, session.self().getUniqueId());
        if (token == null || token.isExpired()) {
            return null;
        }
        return token.getToken();
    }

    @Nullable
    private String getHost() {
        ServerData server = Laby.labyAPI().serverController().getCurrentServerData();
        if (server == null || server.address().getHost().isEmpty()) {
            return null;
        }
        return server.address().getHost();
    }
}

