/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.screenshotuploader.core.uploader.uploaders;

import com.google.gson.JsonObject;
import com.rappytv.screenshotuploader.api.ScreenshotUploaderTextures;
import com.rappytv.screenshotuploader.api.UploadException;
import com.rappytv.screenshotuploader.api.Uploader;
import com.rappytv.screenshotuploader.core.ScreenshotUploaderAddon;
import com.rappytv.screenshotuploader.core.config.UploaderConfig;
import com.rappytv.screenshotuploader.core.config.subconfig.ImgurConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.labymod.api.Laby;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.util.io.web.request.FormData;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import org.jetbrains.annotations.NotNull;

public class ImgurUploader
extends Uploader<ImgurConfig> {
    private static final String UPLOAD_ENDPOINT = "https://api.imgur.com/3/upload";
    private final ScreenshotUploaderAddon addon;

    public ImgurUploader(ScreenshotUploaderAddon addon) {
        super("imgur", "Imgur");
        this.addon = addon;
    }

    @Override
    public Icon getIcon() {
        return ScreenshotUploaderTextures.SpriteUploaders.IMGUR;
    }

    @Override
    @NotNull
    public ImgurConfig getConfig() {
        return ((UploaderConfig)this.addon.configuration()).imgur();
    }

    @Override
    public boolean validateConfig() {
        return true;
    }

    @Override
    public String uploadScreenshot(File file) throws UploadException {
        ArrayList<FormData> formData = new ArrayList<FormData>();
        formData.add(FormData.builder().name("title").value("Screenshot taken by " + Laby.labyAPI().getName()).build());
        if (((Boolean)this.getConfig().addDescription().get()).booleanValue()) {
            formData.add(FormData.builder().name("description").value("Uploaded using the ScreenshotUploader LabyMod Addon").build());
        }
        try {
            formData.add(FormData.builder().name("image").fileName(file.getName()).contentType("image/png").value(file.toPath()).build());
        }
        catch (IOException e) {
            throw new UploadException(e, this);
        }
        String auth = (String)this.getConfig().auth().get();
        String clientId = !auth.isBlank() ? auth : Laby.labyAPI().getUniqueId().toString();
        Response response = ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url("https://api.imgur.com/3/upload?client_id=" + clientId, new Object[0])).method(Request.Method.POST)).form(formData)).addHeader("Authorization", !auth.isBlank() ? "Client-ID " + auth : "")).handleErrorStream()).executeSync();
        if (response.hasException()) {
            throw new UploadException((Throwable)response.exception(), this);
        }
        try {
            int statusCode = response.getStatusCode();
            JsonObject data = ((JsonObject)response.get()).get("data").getAsJsonObject();
            if (statusCode != 200) {
                if (data != null && data.has("error")) {
                    throw new UploadException(data.get("error").getAsString(), this);
                }
                throw new UploadException("Failed to upload file with status " + statusCode, this);
            }
            if (data != null && data.has("link")) {
                return data.get("link").getAsString();
            }
            throw new UploadException("Response body does not contain the file link", this);
        }
        catch (IllegalArgumentException e) {
            throw new UploadException(e, this);
        }
    }
}

