/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.screenshotuploader.core.uploader.uploaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.rappytv.screenshotuploader.api.ScreenshotUploaderTextures;
import com.rappytv.screenshotuploader.api.UploadException;
import com.rappytv.screenshotuploader.api.Uploader;
import com.rappytv.screenshotuploader.core.ScreenshotUploaderAddon;
import com.rappytv.screenshotuploader.core.config.UploaderConfig;
import com.rappytv.screenshotuploader.core.config.subconfig.ZiplineConfig;
import java.io.File;
import java.io.IOException;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.util.io.web.request.AbstractRequest;
import net.labymod.api.util.io.web.request.FormData;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.GsonRequest;
import org.jetbrains.annotations.NotNull;

public class ZiplineUploader
extends Uploader<ZiplineConfig> {
    private final ScreenshotUploaderAddon addon;

    public ZiplineUploader(ScreenshotUploaderAddon addon) {
        super("zipline", "Zipline");
        this.addon = addon;
    }

    @Override
    public Icon getIcon() {
        return ScreenshotUploaderTextures.SpriteUploaders.ZIPLINE;
    }

    @Override
    @NotNull
    public ZiplineConfig getConfig() {
        return ((UploaderConfig)this.addon.configuration()).zipline();
    }

    @Override
    public boolean validateConfig() {
        String base = (String)this.getConfig().base().get();
        String auth = (String)this.getConfig().auth().get();
        return !base.isBlank() && (base.startsWith("https://") || base.startsWith("http://")) && !base.endsWith("/") && !auth.isBlank();
    }

    @Override
    public String uploadScreenshot(File file) throws UploadException {
        Response response;
        FormData fileData;
        try {
            fileData = FormData.builder().name("file").fileName(file.getName()).contentType("image/png").value(file.toPath()).build();
        }
        catch (IOException e) {
            throw new UploadException(e, this);
        }
        AbstractRequest request = ((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)((GsonRequest)Request.ofGson(JsonObject.class).url((String)this.getConfig().base().get() + "/api/upload", new Object[0])).method(Request.Method.POST)).addHeader("Authorization", this.getConfig().auth().get())).addHeader("X-Zipline-Format", (Object)((ZiplineConfig.ZiplineNameFormat)((Object)this.getConfig().nameFormat().get())).toHeader())).form(new FormData[]{fileData})).handleErrorStream();
        String domains = (String)this.getConfig().domains().get();
        int compression = (Integer)this.getConfig().compression().get();
        if (!domains.isBlank()) {
            request.addHeader("X-Zipline-Domain", (Object)domains);
        }
        if (compression > 0) {
            request.addHeader("X-Zipline-Image-Compression", (Object)compression);
        }
        if ((response = request.executeSync()).hasException()) {
            throw new UploadException((Throwable)response.exception(), this);
        }
        try {
            JsonArray files;
            int statusCode = response.getStatusCode();
            JsonObject body = (JsonObject)response.get();
            if (statusCode != 200) {
                Object message = body.has("message") ? body.get("message").getAsString() : (body.has("error") ? body.get("error").getAsString() : "Failed to upload file with status " + statusCode);
                throw new UploadException((String)message, this);
            }
            if (body.has("files") && !(files = body.getAsJsonArray("files")).isEmpty()) {
                return files.get(0).getAsJsonObject().get("url").getAsString();
            }
            throw new UploadException("Response body does not contain the file link", this);
        }
        catch (IllegalArgumentException e) {
            throw new UploadException(e, this);
        }
    }
}

