/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.signsearch.gui.settings;

import com.rappytv.signsearch.utils.SignSearchSettings;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@Link(value="sign-search.lss")
@AutoActivity
public class SignSearchSettingsActivity
extends SimpleActivity {
    private final SignSearchSettings settings;

    public SignSearchSettingsActivity(SignSearchSettings settings) {
        this.settings = settings;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("input-container");
        HorizontalListWidget header = (HorizontalListWidget)new HorizontalListWidget().addId("header").addId("row");
        DivWidget searchDiv = (DivWidget)new DivWidget().addId("input").addId("search-wrapper");
        ComponentWidget searchLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.search").addId("input-label");
        TextFieldWidget searchInput = (TextFieldWidget)new TextFieldWidget().addId("input-item");
        searchInput.setText(this.settings.getSearchString());
        searchInput.updateListener(this.settings::setSearchString);
        searchDiv.addChild((Widget)searchLabel);
        searchDiv.addChild((Widget)searchInput);
        DivWidget advancedSearchDiv = (DivWidget)new DivWidget().addId("checkbox-div");
        ComponentWidget advancedSearchLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.advanced").addId("checkbox-label");
        CheckBoxWidget advancedSearchCheck = (CheckBoxWidget)new CheckBoxWidget().addId("checkbox-item");
        advancedSearchCheck.setState(this.settings.isUsingAdvancedOptions() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        advancedSearchCheck.setPressable(() -> this.settings.setUseAdvancedOptions(advancedSearchCheck.state() == CheckBoxWidget.State.CHECKED));
        advancedSearchDiv.addChild((Widget)advancedSearchLabel);
        advancedSearchDiv.addChild((Widget)advancedSearchCheck);
        ComponentWidget advancedOptionsLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.advanced_label").addId("advanced-options-label");
        DivWidget blacklistDiv = (DivWidget)new DivWidget().addId("row");
        ComponentWidget blacklistLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.blacklist").addId("input-label");
        TextFieldWidget blacklistInput = (TextFieldWidget)new TextFieldWidget().addId("input-item");
        blacklistInput.setText(this.settings.getBlacklistString());
        blacklistInput.updateListener(this.settings::setBlacklistString);
        blacklistDiv.addChild((Widget)blacklistLabel);
        blacklistDiv.addChild((Widget)blacklistInput);
        DivWidget filterEmptyServersDiv = (DivWidget)new DivWidget().addId("checkbox-div");
        DivWidget filterFullServersDiv = (DivWidget)new DivWidget().addId("checkbox-div");
        ComponentWidget filterEmptyServersLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.emptyFilter").addId("checkbox-label");
        CheckBoxWidget filterEmptyServersCheck = (CheckBoxWidget)new CheckBoxWidget().addId("checkbox-item");
        filterEmptyServersCheck.setState(this.settings.areEmptyServersFiltered() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        filterEmptyServersCheck.setPressable(() -> this.settings.setFilterEmptyServer(filterEmptyServersCheck.state() == CheckBoxWidget.State.CHECKED));
        ComponentWidget filterFullServersLabel = (ComponentWidget)ComponentWidget.i18n((String)"signsearch.ui.label.fullFilter").addId("checkbox-label");
        CheckBoxWidget filterFullServersCheck = (CheckBoxWidget)new CheckBoxWidget().addId("checkbox-item");
        filterFullServersCheck.setState(this.settings.areFullServersFiltered() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
        filterFullServersCheck.setPressable(() -> this.settings.setFilterFullServer(filterFullServersCheck.state() == CheckBoxWidget.State.CHECKED));
        filterEmptyServersDiv.addChild((Widget)filterEmptyServersLabel);
        filterEmptyServersDiv.addChild((Widget)filterEmptyServersCheck);
        filterFullServersDiv.addChild((Widget)filterFullServersLabel);
        filterFullServersDiv.addChild((Widget)filterFullServersCheck);
        HorizontalListWidget checkBoxList = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-list");
        checkBoxList.addEntry((Widget)filterEmptyServersDiv);
        checkBoxList.addEntry((Widget)filterFullServersDiv);
        FlexibleContentWidget inputWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("input-list");
        header.addEntry((Widget)searchDiv);
        header.addEntry((Widget)advancedSearchDiv);
        inputWidget.addContent((Widget)header);
        inputWidget.addContent((Widget)advancedOptionsLabel);
        inputWidget.addContent((Widget)blacklistDiv);
        inputWidget.addContent((Widget)checkBoxList);
        content.addChild((Widget)inputWidget);
        ((Document)this.document).addChild((Widget)content);
    }
}

