/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.api;

import com.google.gson.Gson;
import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import de.labystudio.spotifyapi.open.totp.model.Secret;
import de.labystudio.spotifyapi.open.totp.provider.SecretProvider;
import net.labymod.api.BuildData;
import net.labymod.api.util.io.web.request.Request;
import net.labymod.api.util.io.web.request.Response;
import net.labymod.api.util.io.web.request.types.GsonRequest;

public class HttpSecretProvider
implements SecretProvider {
    private static final String URL_SECRET_STORAGE = "https://laby.net/api/v3/spotify/totpSecret?format=1";
    private boolean updateRequired = false;

    public Secret getSecret() {
        if (this.updateRequired) {
            throw new IllegalStateException("The TOTP secret format is outdated. Please update the Spotify addon to the latest version.");
        }
        Response response = ((GsonRequest)((GsonRequest)Request.ofGson(Secret.class, (Gson)OpenSpotifyAPI.GSON).url(URL_SECRET_STORAGE, new Object[0])).userAgent(BuildData.getUserAgent())).executeSync();
        if (response.getStatusCode() == 426) {
            this.updateRequired = true;
            return this.getSecret();
        }
        if (response.isPresent()) {
            return (Secret)response.get();
        }
        throw new IllegalStateException("Failed to retrieve TOTP secret from https://laby.net/api/v3/spotify/totpSecret?format=1.");
    }
}

