/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.hudwidgets;

import de.labystudio.spotifyapi.SpotifyAPI;
import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import net.labymod.addons.spotify.core.SpotifyAddon;
import net.labymod.addons.spotify.core.events.SpotifyConnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyDisconnectEvent;
import net.labymod.addons.spotify.core.events.SpotifyPlaybackChangedEvent;
import net.labymod.addons.spotify.core.events.SpotifyTrackChangedEvent;
import net.labymod.addons.spotify.core.labymod.hudwidgets.elements.widgets.SpotifyWidget;
import net.labymod.api.client.gui.hud.hudwidget.HudWidgetConfig;
import net.labymod.api.client.gui.hud.hudwidget.widget.WidgetHudWidget;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.hud.HudWidgetWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.event.Subscribe;
import net.labymod.api.util.ThreadSafe;
import net.labymod.api.util.bounds.area.RectangleAreaPosition;

public class SpotifyHudWidget
extends WidgetHudWidget<SpotifyHudWidgetConfig> {
    public static final String TRACK_CHANGE_REASON = "track_change";
    public static final String PLAYBACK_CHANGE_REASON = "playback_change";
    public static final String COVER_VISIBILITY_REASON = "cover_visibility";
    public static final String CONNECT_REASON = "connect";
    private final SpotifyAddon addon;
    private final OpenSpotifyAPI openSpotifyAPI;
    private final SpotifyAPI spotifyAPI;
    private final Icon hudWidgetIcon;

    public SpotifyHudWidget(String id, Icon icon, SpotifyAddon addon, OpenSpotifyAPI openSpotifyAPI, SpotifyAPI spotifyAPI) {
        super(id, SpotifyHudWidgetConfig.class);
        this.addon = addon;
        this.hudWidgetIcon = icon;
        this.openSpotifyAPI = openSpotifyAPI;
        this.spotifyAPI = spotifyAPI;
    }

    public void initializePreConfigured(SpotifyHudWidgetConfig config) {
        super.initializePreConfigured((HudWidgetConfig)config);
        config.setEnabled(true);
        config.setAreaIdentifier(RectangleAreaPosition.TOP_RIGHT);
        config.setX(-2.0f);
        config.setY(2.0f);
        config.setParentToTailOfChainIn(RectangleAreaPosition.TOP_RIGHT);
    }

    public void load(SpotifyHudWidgetConfig config) {
        super.load((HudWidgetConfig)config);
        this.setIcon(this.hudWidgetIcon);
        config.showCover.addChangeListener((property, oldValue, newValue) -> ThreadSafe.executeOnRenderThread(() -> this.requestUpdate(COVER_VISIBILITY_REASON)));
    }

    public void initialize(HudWidgetWidget widget) {
        super.initialize(widget);
        boolean editorContext = widget.accessor().isEditor();
        SpotifyWidget spotifyWidget = new SpotifyWidget(this.openSpotifyAPI, this, editorContext);
        widget.addChild((Widget)spotifyWidget);
        widget.addId("spotify");
    }

    public boolean isVisibleInGame() {
        return this.spotifyAPI.isConnected() && this.spotifyAPI.hasTrack();
    }

    @Subscribe
    public void onSpotifyConnect(SpotifyConnectEvent event) {
        ThreadSafe.executeOnRenderThread(() -> {
            if (!this.isEnabled()) {
                return;
            }
            this.requestUpdate(CONNECT_REASON);
        });
    }

    @Subscribe
    public void onSpotifyDisconnect(SpotifyDisconnectEvent event) {
        ThreadSafe.executeOnRenderThread(() -> {
            if (!this.isEnabled()) {
                return;
            }
            this.requestUpdate(CONNECT_REASON);
        });
    }

    @Subscribe
    public void onSpotifyTrackChangedEvent(SpotifyTrackChangedEvent event) {
        ThreadSafe.executeOnRenderThread(() -> {
            if (!this.isEnabled()) {
                return;
            }
            this.requestUpdate(TRACK_CHANGE_REASON);
        });
    }

    @Subscribe
    public void onSpotifyPlayBackChangedEvent(SpotifyPlaybackChangedEvent event) {
        ThreadSafe.executeOnRenderThread(() -> {
            if (!this.isEnabled()) {
                return;
            }
            this.requestUpdate(PLAYBACK_CHANGE_REASON);
        });
    }

    public SpotifyAPI spotifyAPI() {
        return this.spotifyAPI;
    }

    public SpotifyAddon addon() {
        return this.addon;
    }

    public static class SpotifyHudWidgetConfig
    extends HudWidgetConfig {
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> showCover = ConfigProperty.create((Object)true);
        @SwitchWidget.SwitchSetting
        private final ConfigProperty<Boolean> minimizeIngame = ConfigProperty.create((Object)true);

        public ConfigProperty<Boolean> showCover() {
            return this.showCover;
        }

        public ConfigProperty<Boolean> minimizeIngame() {
            return this.minimizeIngame;
        }
    }
}

