/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.hudwidgets.elements.widgets;

import de.labystudio.spotifyapi.SpotifyAPI;
import net.labymod.api.client.gui.lss.property.LssProperty;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.ScreenContext;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.attributes.bounds.Bounds;
import net.labymod.api.util.bounds.Rectangle;
import net.labymod.api.util.math.MathHelper;

@AutoWidget
public class ProgressBarWidget
extends SimpleWidget {
    private final SpotifyAPI spotifyAPI;
    private final LssProperty<Integer> foregroundColor = new LssProperty((Object)65280);

    public ProgressBarWidget(SpotifyAPI api) {
        this.spotifyAPI = api;
    }

    public void renderWidget(ScreenContext context) {
        super.renderWidget(context);
        if (this.spotifyAPI.hasPosition()) {
            float progress = 1.0f / (float)this.spotifyAPI.getTrack().getLength() * (float)this.spotifyAPI.getPosition();
            progress = MathHelper.clamp((float)progress, (float)0.0f, (float)1.0f);
            Bounds bounds = this.bounds();
            context.canvas().submitRect((Rectangle)Rectangle.relative((float)bounds.getLeft(), (float)bounds.getTop(), (float)(bounds.getWidth() * progress), (float)bounds.getHeight()), ((Integer)this.foregroundColor.get()).intValue());
        }
    }

    public LssProperty<Integer> foregroundColor() {
        return this.foregroundColor;
    }
}

