/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core;

import de.labystudio.spotifyapi.SpotifyAPI;
import de.labystudio.spotifyapi.SpotifyAPIFactory;
import de.labystudio.spotifyapi.SpotifyListener;
import de.labystudio.spotifyapi.config.SpotifyConfiguration;
import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import de.labystudio.spotifyapi.open.totp.provider.SecretProvider;
import net.labymod.addons.spotify.core.SpotifyConfiguration;
import net.labymod.addons.spotify.core.api.HttpSecretProvider;
import net.labymod.addons.spotify.core.api.SpotifyApiListener;
import net.labymod.addons.spotify.core.labymod.hudwidgets.SpotifyHudWidget;
import net.labymod.addons.spotify.core.labymod.hudwidgets.SpotifyTextHudWidget;
import net.labymod.addons.spotify.core.labymod.interaction.SpotifyTrackBulletPoint;
import net.labymod.addons.spotify.core.labymod.nametag.SpotifySharedTrack;
import net.labymod.addons.spotify.core.sharing.TrackSharingController;
import net.labymod.addons.spotify.core.util.ReconnectDelay;
import net.labymod.api.Constants;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.entity.player.interaction.InteractionMenuRegistry;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.client.gui.hud.HudWidgetRegistry;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.models.addon.annotation.AddonMain;

@AddonMain
public class SpotifyAddon
extends LabyAddon<SpotifyConfiguration> {
    private final Icon hudIcon = Icon.texture((ResourceLocation)ResourceLocation.create((String)"spotify", (String)"themes/vanilla/textures/settings/hud/spotify32.png")).resolution(64, 64);
    private static SpotifyAddon instance;
    private final SpotifyAPI spotifyAPI;
    private TrackSharingController controller;
    private ReconnectDelay reconnectDelay = ReconnectDelay.DEFAULT;

    public SpotifyAddon() {
        instance = this;
        this.spotifyAPI = SpotifyAPIFactory.create();
    }

    protected void enable() {
        this.registerSettingCategory();
        SpotifyApiListener spotifyApiListener = new SpotifyApiListener(this.spotifyAPI, this);
        this.spotifyAPI.registerListener((SpotifyListener)spotifyApiListener);
        this.initializeSpotifyAndResetDelay();
        HttpSecretProvider secretProvider = new HttpSecretProvider();
        OpenSpotifyAPI openApi = new OpenSpotifyAPI((SecretProvider)secretProvider);
        HudWidgetRegistry registry = this.labyAPI().hudWidgetRegistry();
        registry.register((Object)new SpotifyTextHudWidget("spotify_track", this.hudIcon, this.spotifyAPI));
        registry.register((Object)new SpotifyHudWidget("spotify", this.hudIcon, this, openApi, this.spotifyAPI));
        this.controller = new TrackSharingController(openApi, this);
        this.labyAPI().eventBus().registerListener((Object)this.controller);
        InteractionMenuRegistry menuRegistry = this.labyAPI().interactionMenuRegistry();
        menuRegistry.register((Object)new SpotifyTrackBulletPoint(this, this.controller));
        this.labyAPI().tagRegistry().register("spotify_shared_track", PositionType.BELOW_NAME, (TagRenderer)new SpotifySharedTrack());
    }

    public void initializeSpotifyAndResetDelay() {
        this.setReconnectDelay(ReconnectDelay.DEFAULT);
        this.initializeSpotifyAndResetDelay(true);
    }

    public void initializeSpotifyAndResetDelay(boolean force) {
        if (this.spotifyAPI.isInitialized()) {
            if (!force) {
                return;
            }
            this.spotifyAPI.stop();
        }
        if (!((Boolean)((SpotifyConfiguration)this.configuration()).enabled().get()).booleanValue()) {
            return;
        }
        this.spotifyAPI.initializeAsync(new SpotifyConfiguration.Builder().autoReconnect(false).exceptionReconnectDelay(this.reconnectDelay.getDelay()).nativesDirectory(Constants.Files.NATIVES.resolve("spotify")).build());
    }

    public void disconnect() {
        if (this.spotifyAPI.isInitialized()) {
            this.spotifyAPI.stop();
        }
    }

    public void setReconnectDelay(ReconnectDelay reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public void bumpReconnectDelay() {
        this.reconnectDelay = this.reconnectDelay.next();
    }

    public SpotifyAPI getSpotifyAPI() {
        return this.spotifyAPI;
    }

    protected Class<SpotifyConfiguration> configurationClass() {
        return SpotifyConfiguration.class;
    }

    public TrackSharingController getController() {
        return this.controller;
    }

    public static SpotifyAddon get() {
        return instance;
    }
}

