/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.spotify.core.labymod.hudwidgets.elements.widgets;

import de.labystudio.spotifyapi.SpotifyAPI;
import de.labystudio.spotifyapi.model.MediaKey;
import de.labystudio.spotifyapi.model.Track;
import de.labystudio.spotifyapi.open.OpenSpotifyAPI;
import net.labymod.addons.spotify.core.SpotifyAddon;
import net.labymod.addons.spotify.core.Textures;
import net.labymod.addons.spotify.core.labymod.hudwidgets.SpotifyHudWidget;
import net.labymod.addons.spotify.core.labymod.hudwidgets.elements.widgets.ProgressBarWidget;
import net.labymod.addons.spotify.core.util.TrackUtil;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.hud.hudwidget.HudWidget;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.DivWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.client.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@AutoWidget
@Link(value="spotify-widget.lss")
public class SpotifyWidget
extends FlexibleContentWidget
implements HudWidget.Updatable {
    private static final String PROGRESS_VISIBLE_KEY = "--progress-visible";
    private static final String LARGE_PROGRESS_VISIBLE_KEY = "--large-progress-visible";
    private final OpenSpotifyAPI openSpotifyAPI;
    private final SpotifyHudWidget hudWidget;
    private final SpotifyAPI spotifyAPI;
    private final boolean editorContext;
    private ComponentWidget trackWidget;
    private ComponentWidget artistWidget;
    private IconWidget coverWidget;
    private DivWidget controlsWidget;
    private ComponentWidget currentTimeWidget;
    private ComponentWidget totalTimeWidget;
    private IconWidget playPauseWidget;
    private int lastTickPosition = -1;

    public SpotifyWidget(OpenSpotifyAPI openSpotifyAPI, SpotifyHudWidget hudWidget, boolean editorContext) {
        this.openSpotifyAPI = openSpotifyAPI;
        this.hudWidget = hudWidget;
        this.editorContext = editorContext;
        this.spotifyAPI = this.hudWidget.spotifyAPI();
        boolean hasTrack = this.spotifyAPI.hasTrack() && this.spotifyAPI.hasPosition();
        this.setVariable(PROGRESS_VISIBLE_KEY, hasTrack);
        this.setVariable(LARGE_PROGRESS_VISIBLE_KEY, hasTrack);
        this.setPressable(() -> {
            if (!this.spotifyAPI.isConnected()) {
                this.artistWidget.setVisible(false);
                this.hudWidget.addon().initializeSpotifyAndResetDelay();
            }
        });
    }

    public void initialize(Parent parent) {
        boolean leftAligned;
        boolean maximize;
        super.initialize(parent);
        this.children.clear();
        boolean bl = maximize = this.editorContext || (Boolean)((SpotifyHudWidget.SpotifyHudWidgetConfig)this.hudWidget.getConfig()).minimizeIngame().get() == false;
        if (maximize) {
            this.addId("maximized");
        }
        if (!((Boolean)((SpotifyHudWidget.SpotifyHudWidgetConfig)this.hudWidget.getConfig()).showCover().get()).booleanValue()) {
            this.addId("no-cover");
        }
        this.addId((leftAligned = this.hudWidget.anchor().isLeft()) ? "left" : "right");
        this.coverWidget = new IconWidget(Icon.texture((ResourceLocation)Textures.UNKNOWN_COVER));
        this.coverWidget.addId("cover");
        if (!maximize) {
            ProgressBarWidget minimizedProgressBar = new ProgressBarWidget(this.spotifyAPI);
            minimizedProgressBar.addId("minimized-bar");
            this.coverWidget.addChild((Widget)minimizedProgressBar);
        }
        if (leftAligned) {
            this.addContent((Widget)this.coverWidget);
        }
        FlexibleContentWidget player = new FlexibleContentWidget();
        player.addId("player");
        FlexibleContentWidget textAndControl = new FlexibleContentWidget();
        textAndControl.addId("text-and-control");
        VerticalListWidget text = new VerticalListWidget();
        text.addId("text");
        this.trackWidget = ComponentWidget.empty();
        text.addChild((Widget)this.trackWidget);
        this.artistWidget = ComponentWidget.empty();
        text.addChild((Widget)this.artistWidget);
        this.controlsWidget = new DivWidget();
        this.controlsWidget.addId("controls");
        this.playPauseWidget = new IconWidget(this.spotifyAPI.isPlaying() ? Textures.SpriteControls.PAUSE : Textures.SpriteControls.PLAY);
        this.playPauseWidget.addId("play");
        this.playPauseWidget.setPressable(() -> {
            this.playPauseWidget.icon().set((Object)(this.spotifyAPI.isPlaying() ? Textures.SpriteControls.PLAY : Textures.SpriteControls.PAUSE));
            this.pressMediaKey(MediaKey.PLAY_PAUSE);
        });
        this.controlsWidget.addChild((Widget)this.playPauseWidget);
        IconWidget previousTrack = new IconWidget(Textures.SpriteControls.PREVIOUS);
        previousTrack.addId("previous");
        previousTrack.setPressable(() -> this.pressMediaKey(MediaKey.PREV));
        this.controlsWidget.addChild((Widget)previousTrack);
        IconWidget nextTrack = new IconWidget(Textures.SpriteControls.NEXT);
        nextTrack.addId("next");
        nextTrack.setPressable(() -> this.pressMediaKey(MediaKey.NEXT));
        this.controlsWidget.addChild((Widget)nextTrack);
        if (leftAligned) {
            textAndControl.addFlexibleContent((Widget)text);
            textAndControl.addContent((Widget)this.controlsWidget);
        } else {
            textAndControl.addContent((Widget)this.controlsWidget);
            textAndControl.addFlexibleContent((Widget)text);
        }
        player.addFlexibleContent((Widget)textAndControl);
        FlexibleContentWidget progress = new FlexibleContentWidget();
        progress.addId("progress");
        this.currentTimeWidget = ComponentWidget.empty();
        progress.addContent((Widget)this.currentTimeWidget);
        ProgressBarWidget progressBar = new ProgressBarWidget(this.spotifyAPI);
        progressBar.addId("full-bar");
        progress.addFlexibleContent((Widget)progressBar);
        this.totalTimeWidget = ComponentWidget.empty();
        progress.addContent((Widget)this.totalTimeWidget);
        player.addContent((Widget)progress);
        this.addContent((Widget)player);
        if (!leftAligned) {
            this.addContent((Widget)this.coverWidget);
        }
        this.updateTrack(this.spotifyAPI.getTrack());
    }

    public void tick() {
        super.tick();
        boolean hasTrack = this.spotifyAPI.hasTrack() && this.spotifyAPI.hasPosition();
        this.setVariable(PROGRESS_VISIBLE_KEY, hasTrack);
        if (!this.editorContext) {
            boolean isChatOpen = Laby.references().chatAccessor().isChatOpen();
            if (!((Boolean)((SpotifyHudWidget.SpotifyHudWidgetConfig)this.hudWidget.getConfig()).minimizeIngame().get()).booleanValue() || isChatOpen) {
                this.addId("maximized");
                this.setVariable(LARGE_PROGRESS_VISIBLE_KEY, hasTrack);
            } else {
                this.removeId("maximized");
                this.setVariable(LARGE_PROGRESS_VISIBLE_KEY, false);
            }
        } else {
            this.setVariable(LARGE_PROGRESS_VISIBLE_KEY, hasTrack);
        }
        if (this.spotifyAPI.hasPosition() && this.currentTimeWidget != null) {
            int position = this.spotifyAPI.getPosition() / 1000;
            if (this.lastTickPosition < 0 || this.lastTickPosition != position) {
                String positionDisplay = String.format("%d:%02d", position / 60, position % 60);
                this.currentTimeWidget.setComponent((Component)Component.text((String)positionDisplay));
                this.lastTickPosition = position;
            }
        }
    }

    public void update(@Nullable String reason) {
        if (reason == null || reason.equals("connect")) {
            this.reInitialize();
            return;
        }
        if (reason.equals("playback_change") && this.playPauseWidget != null) {
            this.playPauseWidget.icon().set((Object)(this.spotifyAPI.isPlaying() ? Textures.SpriteControls.PAUSE : Textures.SpriteControls.PLAY));
        }
        if (reason.equals("track_change")) {
            this.updateTrack(this.spotifyAPI.getTrack());
        }
        if (reason.equals("cover_visibility")) {
            boolean showCover = (Boolean)((SpotifyHudWidget.SpotifyHudWidgetConfig)this.hudWidget.getConfig()).showCover().get();
            if (showCover) {
                this.removeId("no-cover");
            } else {
                this.addId("no-cover");
            }
        }
    }

    private void updateTrack(Track track) {
        if (this.trackWidget == null || this.artistWidget == null) {
            return;
        }
        this.trackWidget.setComponent((Component)Component.text((String)(track == null ? "Not playing" : track.getName())));
        this.artistWidget.setComponent((Component)Component.text((String)(track == null ? "Click to retry" : track.getArtist())));
        this.artistWidget.setVisible(true);
        if (track == null || track.getLength() <= 0 || !track.isIdValid()) {
            this.controlsWidget.setVisible(false);
            return;
        }
        this.controlsWidget.setVisible(true);
        int length = track.getLength() / 1000;
        String totalTimeDisplay = String.format("%d:%02d", length / 60, length % 60);
        this.totalTimeWidget.setComponent((Component)Component.text((String)totalTimeDisplay));
        Icon icon = TrackUtil.createIcon(this.openSpotifyAPI, track);
        this.coverWidget.icon().set((Object)icon);
    }

    private void pressMediaKey(MediaKey mediaKey) {
        if (!this.spotifyAPI.isConnected()) {
            return;
        }
        try {
            this.spotifyAPI.pressMediaKey(mediaKey);
        }
        catch (IllegalArgumentException e) {
            SpotifyAddon.get().logger().error((CharSequence)"Failed to press media key", (Throwable)e);
        }
    }
}

